<?php

namespace Database\Seeders;

use App\Models\Barang;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class BarangSeeder extends Seeder
{
    public function run(): void
    {
        $barangs = [
            // --- PRODI TPK (ID 1-5) ---
            ['id_lab' => 1, 'nama_barang' => 'Spektrofotometer UV-Vis', 'merk_tipe' => 'Shimadzu UV-1900i', 'kode_bmn' => 'BMN-TPK-001', 'kategori' => 'Alat Laboratorium', 'tahun_perolehan' => 2022],
            ['id_lab' => 1, 'nama_barang' => 'pH Meter Digital', 'merk_tipe' => 'Hanna Instruments HI98107', 'kode_bmn' => 'BMN-TPK-002', 'kategori' => 'Alat Laboratorium', 'tahun_perolehan' => 2023],
            ['id_lab' => 2, 'nama_barang' => 'Instalasi Pengolahan Air Limbah (Mini)', 'merk_tipe' => 'Custom Tech 2021', 'kode_bmn' => 'BMN-TPK-003', 'kategori' => 'Alat Laboratorium', 'tahun_perolehan' => 2021],
            ['id_lab' => 3, 'nama_barang' => 'Inkubator Mikrobiologi', 'merk_tipe' => 'Memmert IN55', 'kode_bmn' => 'BMN-TPK-004', 'kategori' => 'Alat Laboratorium', 'tahun_perolehan' => 2020],
            ['id_lab' => 4, 'nama_barang' => 'Drum Tanning Kayu Lapis', 'merk_tipe' => 'Local Machine V2', 'kode_bmn' => 'BMN-TPK-005', 'kategori' => 'Alat Laboratorium', 'tahun_perolehan' => 2019],
            ['id_lab' => 5, 'nama_barang' => 'Mesin Spray Finishing Kulit', 'merk_tipe' => 'Bergi Superflat', 'kode_bmn' => 'BMN-TPK-006', 'kategori' => 'Alat Laboratorium', 'tahun_perolehan' => 2021],

            // --- PRODI TPPK (ID 6-12) ---
            ['id_lab' => 6, 'nama_barang' => 'PC Workstation Desain', 'merk_tipe' => 'Dell Precision 3660', 'kode_bmn' => 'BMN-TPPK-001', 'kategori' => 'Elektronik', 'tahun_perolehan' => 2023],
            ['id_lab' => 7, 'nama_barang' => 'Mesin Seset Kulit (Skiving)', 'merk_tipe' => 'Fortuna V50', 'kode_bmn' => 'BMN-TPPK-002', 'kategori' => 'Alat Laboratorium', 'tahun_perolehan' => 2022],
            ['id_lab' => 8, 'nama_barang' => 'Mesin Jahit Upper Sepatu', 'merk_tipe' => 'Juki 1541-7', 'kode_bmn' => 'BMN-TPPK-003', 'kategori' => 'Alat Laboratorium', 'tahun_perolehan' => 2021],
            ['id_lab' => 10, 'nama_barang' => 'Manekin Full Body', 'merk_tipe' => 'Premium Fiberglass', 'kode_bmn' => 'BMN-TPPK-004', 'kategori' => 'Furnitur', 'tahun_perolehan' => 2023],
            ['id_lab' => 11, 'nama_barang' => 'Mesin Jahit High Speed', 'merk_tipe' => 'Singer 191D', 'kode_bmn' => 'BMN-TPPK-005', 'kategori' => 'Alat Laboratorium', 'tahun_perolehan' => 2022],
            ['id_lab' => 12, 'nama_barang' => 'Mesin Embossing Kulit', 'merk_tipe' => 'Hydraulic Press HP-20', 'kode_bmn' => 'BMN-TPPK-006', 'kategori' => 'Alat Laboratorium', 'tahun_perolehan' => 2021],

            // --- PRODI TPKP (ID 13-17) ---
            ['id_lab' => 13, 'nama_barang' => 'Viskometer Brookfield', 'merk_tipe' => 'LVDV-E', 'kode_bmn' => 'BMN-TPKP-001', 'kategori' => 'Alat Laboratorium', 'tahun_perolehan' => 2022],
            ['id_lab' => 14, 'nama_barang' => 'Server Lab Komputasi', 'merk_tipe' => 'HP ProLiant DL380', 'kode_bmn' => 'BMN-TPKP-002', 'kategori' => 'Elektronik', 'tahun_perolehan' => 2020],
            ['id_lab' => 15, 'nama_barang' => 'Universal Testing Machine (UTM)', 'merk_tipe' => 'Instron 3400', 'kode_bmn' => 'BMN-TPKP-003', 'kategori' => 'Alat Laboratorium', 'tahun_perolehan' => 2023],
            ['id_lab' => 16, 'nama_barang' => 'Two Roll Mill Karet', 'merk_tipe' => 'Mixing Mill 6 Inch', 'kode_bmn' => 'BMN-TPKP-004', 'kategori' => 'Alat Laboratorium', 'tahun_perolehan' => 2021],
            ['id_lab' => 17, 'nama_barang' => 'Mesin Injection Molding Plastik', 'merk_tipe' => 'Haitian MA1200', 'kode_bmn' => 'BMN-TPKP-005', 'kategori' => 'Alat Laboratorium', 'tahun_perolehan' => 2022],
        ];

        foreach ($barangs as $val) {
            Barang::updateOrCreate(
                ['kode_bmn' => $val['kode_bmn']], // Unik berdasarkan kode BMN
                array_merge($val, [
                    'status_kondisi' => 'Normal',
                    'klasifikasi_fungsi' => 'Pendidikan'
                ])
            );
        }
    }
}