<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class LaboratoriumSeeder extends Seeder
{
    public function run(): void
    {
        $units = [
            // PRODI ID 1: TPK (Teknologi Pengolahan Kulit)
            ['nama_lab' => 'Lab Kimia Terapan', 'prodi_id' => 1],
            ['nama_lab' => 'Lab Uji Kulit & Biokimia', 'prodi_id' => 1],
            ['nama_lab' => 'Lab Lingkungan (Limbah)', 'prodi_id' => 1],
            ['nama_lab' => 'Workshop Pasca Tanning', 'prodi_id' => 1],
            ['nama_lab' => 'Workshop Finishing Kulit', 'prodi_id' => 1],

            // PRODI ID 2: TPPK (Teknologi Pengolahan Produk Kulit)
            ['nama_lab' => 'Lab Komputer Design (CAD)', 'prodi_id' => 2],
            ['nama_lab' => 'Workshop Jahit I', 'prodi_id' => 2],
            ['nama_lab' => 'Workshop Jahit II', 'prodi_id' => 2],
            ['nama_lab' => 'Workshop Perakitan (Assembling)', 'prodi_id' => 2],
            ['nama_lab' => 'Workshop Alas Kaki', 'prodi_id' => 2],
            ['nama_lab' => 'Workshop Barang Kulit', 'prodi_id' => 2],
            ['nama_lab' => 'Workshop Pola', 'prodi_id' => 2],

            // PRODI ID 3: TPKP (Teknologi Pengolahan Karet & Plastik)
            ['nama_lab' => 'Lab Fisika & Kimia Polimer', 'prodi_id' => 3],
            ['nama_lab' => 'Lab Pengujian Plastik & Karet', 'prodi_id' => 3],
            ['nama_lab' => 'Workshop Injeksi Plastik', 'prodi_id' => 3],
            ['nama_lab' => 'Workshop Ekstrusi', 'prodi_id' => 3],
            ['nama_lab' => 'Workshop Komposit & Karet', 'prodi_id' => 3],
        ];

        foreach ($units as $unit) {
            DB::table('laboratoriums')->updateOrInsert(
                ['nama_lab' => $unit['nama_lab']], // Cek agar tidak duplikat
                ['prodi_id' => $unit['prodi_id'], 'created_at' => now(), 'updated_at' => now()]
            );
        }
    }
}