@extends('layouts.admin')

@section('content')
<div class="container-fluid py-4" style="background: #f8fafc; min-height: 100vh; color: #1e293b;">
    {{-- Header Section --}}
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="fw-bold mb-0 text-dark">Master Barang</h2>
            <p class="text-muted small">Kelola inventaris aset dan alat laboratorium</p>
        </div>
        <button class="btn btn-primary rounded-pill px-4 shadow-sm fw-bold" data-bs-toggle="modal" data-bs-target="#modalTambahBarang">
            <i class="bi bi-plus-circle me-2"></i> Tambah Alat Baru
        </button>
    </div>

    {{-- Alert Success --}}
    @if(session('success'))
        <div class="alert alert-success border-0 bg-success bg-opacity-10 text-success rounded-4 mb-4 d-flex align-items-center shadow-sm">
            <i class="bi bi-check-circle-fill me-2"></i>
            {{ session('success') }}
        </div>
    @endif

    {{-- Table Card --}}
    <div class="card border-0 rounded-4 shadow-sm bg-white">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th class="px-4 py-3 border-0 text-muted small text-uppercase fw-bold">Aset (BMN)</th>
                            <th class="py-3 border-0 text-muted small text-uppercase fw-bold">Nama Alat</th>
                            <th class="py-3 border-0 text-muted small text-uppercase fw-bold">Lokasi Unit</th> {{-- Kolom Baru --}}
                            <th class="py-3 border-0 text-muted small text-uppercase fw-bold">Kategori</th>
                            <th class="py-3 border-0 text-muted small text-uppercase fw-bold text-end px-4">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="border-top-0">
                        @foreach($barangs as $barang)
                        <tr class="align-middle">
                            <td class="px-4 py-3 fw-bold text-dark">{{ $barang->kode_bmn }}</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    @if($barang->foto_identifikasi)
                                        <img src="{{ asset('uploads/barangs/' . $barang->foto_identifikasi) }}" class="rounded-3 me-3 shadow-sm" style="width: 40px; height: 40px; object-fit: cover;">
                                    @else
                                        <div class="bg-light rounded-3 me-3 d-flex align-items-center justify-content-center border" style="width: 40px; height: 40px;">
                                            <i class="bi bi-box text-muted"></i>
                                        </div>
                                    @endif
                                    <span class="fw-medium">{{ $barang->nama_barang }}</span>
                                </div>
                            </td>
                            <td>
                                <span class="text-dark small fw-medium">
                                    <i class="bi bi-geo-alt text-danger me-1"></i>
                                    {{ $barang->lab->nama_lab ?? 'Tidak Ada Lokasi' }} {{-- Menampilkan Nama Lab --}}
                                </span>
                            </td>
                            <td>
                                <span class="badge bg-primary bg-opacity-10 text-primary rounded-pill px-3">
                                    {{ $barang->kategori ?? '-' }}
                                </span>
                            </td>
                            <td class="text-end px-4">
                                <button class="btn btn-sm btn-light border text-primary rounded-circle me-1" data-bs-toggle="modal" data-bs-target="#modalEdit{{ $barang->id }}" title="Edit">
                                    <i class="bi bi-pencil-square"></i>
                                </button>
                                <form action="{{ route('barangs.destroy', $barang->id) }}" method="POST" class="d-inline">
                                    @csrf @method('DELETE')
                                    <button class="btn btn-sm btn-light border text-danger rounded-circle" onclick="return confirm('Hapus aset ini?')" title="Hapus">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>

                        {{-- Modal Edit --}}
                        <div class="modal fade" id="modalEdit{{ $barang->id }}" tabindex="-1">
                            <div class="modal-dialog modal-lg modal-dialog-centered">
                                <div class="modal-content border-0 rounded-4 shadow-lg">
                                    <form action="{{ route('barangs.update', $barang->id) }}" method="POST" enctype="multipart/form-data">
                                        @csrf @method('PUT')
                                        <div class="modal-header border-bottom p-4">
                                            <h5 class="modal-title d-flex align-items-center fw-bold text-dark">
                                                <i class="bi bi-pencil-square me-2 text-primary"></i> Edit Detail Alat
                                            </h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                        </div>
                                        <div class="modal-body p-4 bg-light bg-opacity-50">
                                            <div class="mb-4">
                                                <label class="form-label text-muted small fw-bold text-uppercase">Lokasi Laboratorium</label>
                                                <select name="id_lab" class="form-select border-2 py-2 px-3 rounded-3" required>
                                                    @foreach($labs as $lab)
                                                        <option value="{{ $lab->id }}" {{ $barang->id_lab == $lab->id ? 'selected' : '' }}>
                                                            {{ $lab->nama_lab }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="mb-4">
                                                <label class="form-label text-muted small fw-bold text-uppercase">Nama Alat</label>
                                                <input type="text" name="nama_barang" class="form-control border-2 py-2 px-3 rounded-3" value="{{ $barang->nama_barang }}" required>
                                            </div>
                                            <div class="row g-4 mb-4">
                                                <div class="col-md-6">
                                                    <label class="form-label text-muted small fw-bold text-uppercase">Merk/Tipe</label>
                                                    <input type="text" name="merk_tipe" class="form-control border-2 py-2 px-3 rounded-3" value="{{ $barang->merk_tipe }}">
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label text-muted small fw-bold text-uppercase">Kode Aset (BMN)</label>
                                                    <input type="text" name="kode_bmn" class="form-control border-2 py-2 px-3 rounded-3" value="{{ $barang->kode_bmn }}" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer border-top p-4">
                                            <button type="button" class="btn btn-light rounded-pill px-4" data-bs-dismiss="modal">Batal</button>
                                            <button type="submit" class="btn btn-primary rounded-pill px-4 shadow">Simpan Perubahan</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

{{-- Modal Tambah --}}
<div class="modal fade" id="modalTambahBarang" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content border-0 rounded-4 shadow-lg">
            <form action="{{ route('barangs.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-header border-bottom p-4 bg-white">
                    <h5 class="modal-title d-flex align-items-center fw-bold text-dark">
                        <i class="bi bi-plus-square-dotted me-2 text-primary"></i> DETAIL ALAT BARU
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body p-4" style="background-color: #fbfcfd;">
                    {{-- Row: Lokasi Lab (Hanya muncul untuk Admin/SuperAdmin) --}}
                    <div class="mb-4">
                        <label class="form-label text-muted small fw-bold text-uppercase">Lokasi Penempatan Alat</label>
                        <select name="id_lab" class="form-select border-2 py-2 px-3 rounded-3 shadow-sm" required>
                            <option value="" selected disabled>-- Pilih Laboratorium/Workshop --</option>
                            @foreach($labs as $lab)
                                <option value="{{ $lab->id }}">{{ $lab->nama_lab }}</option>
                            @endforeach
                        </select>
                    </div>

                    {{-- Row 1: Nama Alat --}}
                    <div class="mb-4">
                        <label class="form-label text-muted small fw-bold text-uppercase" style="letter-spacing: 0.5px;">Nama Alat</label>
                        <input type="text" name="nama_barang" class="form-control border-2 py-2 px-3 rounded-3 shadow-sm" placeholder="Masukkan Nama Alat" required>
                    </div>

                    {{-- Row 2: Merk & Kode Aset --}}
                    <div class="row g-4 mb-4">
                        <div class="col-md-6">
                            <label class="form-label text-muted small fw-bold text-uppercase" style="letter-spacing: 0.5px;">Merk/Tipe</label>
                            <input type="text" name="merk_tipe" class="form-control border-2 py-2 px-3 rounded-3 shadow-sm" placeholder="Contoh: Asus Vivobook">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label text-muted small fw-bold text-uppercase" style="letter-spacing: 0.5px;">Kode Aset (BMN)</label>
                            <input type="text" name="kode_bmn" class="form-control border-2 py-2 px-3 rounded-3 shadow-sm" placeholder="Masukkan Kode BMN" required>
                        </div>
                    </div>

                    {{-- Row 3: Tahun & Kategori --}}
                    <div class="row g-4 mb-4">
                        <div class="col-md-6">
                            <label class="form-label text-muted small fw-bold text-uppercase" style="letter-spacing: 0.5px;">Thn Perolehan</label>
                            <input type="number" name="tahun_perolehan" class="form-control border-2 py-2 px-3 rounded-3 shadow-sm" placeholder="Pilih Tahun">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label text-muted small fw-bold text-uppercase" style="letter-spacing: 0.5px;">Kategori</label>
                            <select name="kategori" class="form-select border-2 py-2 px-3 rounded-3 shadow-sm">
                                <option value="" selected disabled>-- Pilih Kategori --</option>
                                <option value="Elektronik">Elektronik</option>
                                <option value="Alat Laboratorium">Alat Laboratorium</option>
                                <option value="Furnitur">Furnitur</option>
                            </select>
                        </div>
                    </div>

                    {{-- Row 4: Klasifikasi Fungsi --}}
                    <div class="mb-4">
                        <label class="form-label text-muted small fw-bold text-uppercase" style="letter-spacing: 0.5px;">Klasifikasi Fungsi</label>
                        <select name="klasifikasi_fungsi" class="form-select border-2 py-2 px-3 rounded-3 shadow-sm">
                            <option value="Pendidikan">Pendidikan</option>
                            <option value="Penelitian">Penelitian</option>
                            <option value="Operasional">Operasional</option>
                        </select>
                    </div>

                    {{-- Row 5: Foto --}}
                    <div class="mb-2">
                        <label class="form-label text-muted small fw-bold text-uppercase" style="letter-spacing: 0.5px;">Foto Identifikasi Alat</label>
                        <input type="file" name="foto_identifikasi" class="form-control border-2 py-2 px-3 rounded-3 shadow-sm">
                    </div>
                </div>
                <div class="modal-footer border-top p-4 bg-white">
                    <button type="button" class="btn btn-light text-muted fw-bold px-4 rounded-pill" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary rounded-pill px-5 shadow fw-bold">Simpan Aset</button>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
    /* Light Mode Focus Styling */
    .form-control, .form-select {
        border-color: #e2e8f0;
        background-color: #ffffff;
        transition: all 0.2s ease-in-out;
    }
    .form-control:focus, .form-select:focus {
        background-color: #fff !important;
        border-color: #3b82f6 !important;
        color: #1e293b !important;
        box-shadow: 0 0 0 4px rgba(59, 130, 246, 0.1) !important;
    }
    .table thead th {
        font-size: 0.75rem;
        letter-spacing: 0.05em;
    }
    .btn-light {
        background-color: #f8fafc;
        border-color: #e2e8f0;
    }
    .btn-light:hover {
        background-color: #f1f5f9;
        border-color: #cbd5e1;
    }
</style>
@endsection