@extends('layouts.admin')

@section('title', 'Dashboard Kaprodi')

@section('content')
<div class="container-fluid px-4 py-4" style="background-color: #f8fafc; min-height: 100vh;">
    
    {{-- A. Header & Info Prodi --}}
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h3 class="fw-bold text-dark mb-1">Dashboard Monitoring Perawatan</h3>
            <p class="text-muted small mb-0">
                Unit Kerja: <span class="badge bg-primary bg-opacity-10 text-primary px-3 rounded-pill border border-primary border-opacity-25">{{ Auth::user()->prodi_id == 1 ? 'Teknologi Pengolahan Kulit (TPK)' : (Auth::user()->prodi_id == 2 ? 'Teknologi Pengolahan Produk Kulit (TPPK)' : 'Teknologi Pengolahan Karet & Plastik (TPKP)') }}</span>
            </p>
        </div>
    </div>

    {{-- B. Filter Data (Pusat Kendali) --}}
    <div class="card border-0 shadow-sm rounded-4 mb-4 bg-white">
        <div class="card-body p-4">
            <h6 class="fw-bold text-dark mb-3"><i class="bi bi-sliders me-2 text-primary"></i>Filter Unit & Waktu</h6>
            <form action="{{ route('kaprodi.dashboard') }}" method="GET" class="row g-3">
                <div class="col-md-3">
                    <label class="small text-muted fw-bold text-uppercase mb-1" style="font-size: 10px;">Sub-Unit (Lab/Workshop)</label>
                    <select name="lab_id" class="form-select border-2 bg-light bg-opacity-50 rounded-3">
                        <option value="">Semua Unit Prodi</option>
                        @foreach($labs as $lab)
                            <option value="{{ $lab->id }}" {{ request('lab_id') == $lab->id ? 'selected' : '' }}>
                                {{ $lab->nama_lab }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="small text-muted fw-bold text-uppercase mb-1" style="font-size: 10px;">Rentang Tanggal</label>
                    <div class="input-group border-2">
                        <input type="date" name="start_date" class="form-control border-2 bg-light bg-opacity-50 rounded-start-3" value="{{ request('start_date') }}">
                        <span class="input-group-text border-2 bg-light small">s/d</span>
                        <input type="date" name="end_date" class="form-control border-2 bg-light bg-opacity-50 rounded-end-3" value="{{ request('end_date') }}">
                    </div>
                </div>
                <div class="col-md-3">
                    <label class="small text-muted fw-bold text-uppercase mb-1" style="font-size: 10px;">Status Progres</label>
                    <select name="status" class="form-select border-2 bg-light bg-opacity-50 rounded-3">
                        <option value="">Semua Progres</option>
                        <option value="pending_kaprodi" {{ request('status') == 'pending_kaprodi' ? 'selected' : '' }}>Menunggu Persetujuan Anda</option>
                        <option value="repairing" {{ request('status') == 'repairing' ? 'selected' : '' }}>Sedang Diperbaiki</option>
                        <option value="closed" {{ request('status') == 'closed' ? 'selected' : '' }}>Selesai (Normal)</option>
                    </select>
                </div>
                <div class="col-md-2 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100 rounded-3 shadow fw-bold py-2">Terapkan</button>
                </div>
            </form>
        </div>
    </div>

    {{-- C. Widget Ringkasan (KPI) --}}
    <div class="row g-4 mb-5">
        <div class="col-xl-3 col-md-6">
            <div class="card border-0 shadow-sm rounded-4 bg-white border-start border-primary border-4 h-100 transition-all hover-lift">
                <div class="card-body p-4">
                    <small class="text-muted d-block fw-bold text-uppercase mb-2" style="font-size: 10px; letter-spacing: 1px;">Total Pengajuan</small>
                    <h3 class="fw-extrabold mb-1 text-dark">{{ $totalPengajuan }}</h3>
                    <p class="mb-0 small text-primary"><i class="bi bi-file-earmark-text me-1"></i>Seluruh Tiket Prodi</p>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card border-0 shadow-sm rounded-4 bg-white border-start border-warning border-4 h-100 transition-all hover-lift">
                <div class="card-body p-4">
                    <small class="text-muted d-block fw-bold text-uppercase mb-2" style="font-size: 10px; letter-spacing: 1px;">Tahap Pudir 2</small>
                    <h3 class="fw-extrabold mb-1 text-warning">{{ $disetujui }}</h3>
                    <p class="mb-0 small text-muted"><i class="bi bi-shield-lock me-1"></i>Proses Anggaran</p>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card border-0 shadow-sm rounded-4 bg-white border-start border-info border-4 h-100 transition-all hover-lift">
                <div class="card-body p-4">
                    <small class="text-muted d-block fw-bold text-uppercase mb-2" style="font-size: 10px; letter-spacing: 1px;">Perbaikan</small>
                    <h3 class="fw-extrabold mb-1 text-info">{{ $sedangDikerjakan }}</h3>
                    <p class="mb-0 small text-muted"><i class="bi bi-gear-wide-connected me-1"></i>Sedang Dikerjakan</p>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card border-0 shadow-sm rounded-4 bg-white border-start border-success border-4 h-100 transition-all hover-lift">
                <div class="card-body p-4">
                    <small class="text-muted d-block fw-bold text-uppercase mb-2" style="font-size: 10px; letter-spacing: 1px;">Selesai</small>
                    <h3 class="fw-extrabold mb-1 text-success">{{ $selesai }}</h3>
                    <p class="mb-0 small text-muted"><i class="bi bi-check-circle me-1"></i>Unit Kembali Normal</p>
                </div>
            </div>
        </div>
    </div>

    {{-- D. Tabel Riwayat (Sinkronisasi Master Barang) --}}
    <div class="card border-0 shadow-sm rounded-4 overflow-hidden bg-white">
        <div class="card-header bg-white border-0 py-4 px-4 d-flex justify-content-between align-items-center">
            <h5 class="fw-bold mb-0 text-dark">Daftar Pengajuan Perawatan</h5>
            <span class="text-muted small">Update: {{ now()->translatedFormat('d F Y, H:i') }} WIB</span>
        </div>
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="bg-light-subtle border-bottom">
                    <tr class="text-uppercase small fw-bold text-muted" style="font-size: 11px; letter-spacing: 1px;">
                        <th class="ps-4">ID Tiket</th>
                        <th>Informasi Alat</th>
                        <th>Sub-Unit Pengaju</th>
                        <th>Tgl Ajuan</th>
                        <th class="text-center">Tingkat Kerusakan</th>
                        <th>Status Saat Ini</th>
                        <th class="text-center pe-4">Aksi</th>
                    </tr>
                </thead>
                <tbody class="border-top-0">
                    @forelse($maintenances as $item)
                    <tr>
                        <td class="ps-4">
                            <span class="text-primary fw-bold">{{ $item->formatted_id }}</span>
                        </td>
                        <td>
                            {{-- REVISI: Mengambil data dari Master Barang (relasi barang) --}}
                            <div class="fw-bold text-dark">{{ $item->barang->nama_barang ?? 'Alat Tidak Diketahui' }}</div>
                            <div class="text-muted font-monospace small" style="font-size: 10px;">
                                <i class="bi bi-hash me-1 text-primary"></i>BMN: {{ $item->barang->kode_bmn ?? 'N/A' }}
                            </div>
                        </td>
                        <td>
                            <div class="d-flex align-items-center">
                                <span class="badge bg-light text-dark border fw-medium px-3 py-2 rounded-3">
                                    <i class="bi bi-building me-2 text-primary"></i>{{ $item->lab->nama_lab ?? 'N/A' }}
                                </span>
                            </div>
                        </td>
                        <td>
                            <div class="text-dark small">{{ $item->created_at->format('d/m/Y') }}</div>
                            <div class="text-muted" style="font-size: 10px;">{{ $item->created_at->format('H:i') }} WIB</div>
                        </td>
                        <td class="text-center">
                            @php
                                $damageColor = [
                                    'Ringan' => 'bg-success-subtle text-success border-success',
                                    'Sedang' => 'bg-warning-subtle text-warning border-warning',
                                    'Berat'  => 'bg-danger-subtle text-danger border-danger',
                                ][$item->damage_level] ?? 'bg-light text-muted border-secondary';
                            @endphp
                            <span class="badge {{ $damageColor }} border px-2 py-1 rounded-2 fw-bold" style="font-size: 9px; letter-spacing: 0.5px;">
                                {{ strtoupper($item->damage_level ?? 'UMUM') }}
                            </span>
                        </td>
                        <td>
                            @php
                                $statusColor = [
                                    'pending_kaprodi' => 'bg-warning text-white',
                                    'repairing' => 'bg-info text-white',
                                    'closed' => 'bg-success text-white',
                                    'rejected' => 'bg-danger text-white'
                                ][$item->status] ?? 'bg-light text-dark';
                            @endphp
                            <span class="badge {{ $statusColor }} px-3 py-2 rounded-pill shadow-xs" style="font-size: 9px; letter-spacing: 0.5px;">
                                <span class="me-1">●</span> {{ str_replace('_', ' ', strtoupper($item->status)) }}
                            </span>
                        </td>
                        <td class="text-center pe-4">
                            @include('layouts.actions')
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center py-5">
                            <img src="https://cdn-icons-png.flaticon.com/512/7486/7486744.png" width="80" class="mb-3 opacity-25">
                            <p class="text-muted small">Tidak ada riwayat pengajuan pemeliharaan untuk Prodi ini.</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        @if($maintenances instanceof \Illuminate\Pagination\LengthAwarePaginator)
        <div class="card-footer bg-white border-top py-3 px-4">
            {{ $maintenances->links() }}
        </div>
        @endif
    </div>
</div>

<style>
    .hover-lift:hover { transform: translateY(-3px); box-shadow: 0 15px 30px rgba(0,0,0,0.08) !important; transition: all 0.3s; }
    .transition-all { transition: all 0.3s ease; }
    .fw-extrabold { font-weight: 800; }
    .shadow-xs { box-shadow: 0 1px 2px rgba(0,0,0,0.05); }
    .form-control:focus, .form-select:focus {
        border-color: #3b82f6 !important;
        box-shadow: 0 0 0 4px rgba(59, 130, 246, 0.1) !important;
    }
</style>
@endsection