@extends('layouts.admin')

@section('content')
<div class="container-fluid p-4">
    <div class="card border-0 shadow-sm rounded-4">
        <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
            <h5 class="mb-0 fw-bold">Unit Management</h5>
            <button type="button" class="btn btn-primary rounded-3" data-bs-toggle="modal" data-bs-target="#tambahModal">
                <i class="bi bi-plus-lg me-2"></i>Tambah Lab/Workshop
            </button>
        </div>
        <div class="card-body">
            <table class="table table-bordered align-middle">
                <thead class="bg-light">
                    <tr class="text-center">
                        <th width="50">No</th>
                        <th>Lab/Workshop</th>
                        <th>Prodi</th>
                        <th width="200">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($units as $index => $unit)
                    <tr>
                        <td class="text-center">{{ $index + 1 }}</td>
                        <td>{{ $unit->nama_lab }}</td>
                        <td class="text-center">{{ $unit->prodi }}</td>
                        <td class="text-center">
                            <button class="btn btn-sm btn-outline-primary me-1">Edit</button>
                            <button class="btn btn-sm btn-outline-danger">Delete</button>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <div class="modal fade" id="tambahModal" tabindex="-1">
        <div class="modal-dialog">
            <form action="{{ route('units.store') }}" method="POST" class="modal-content">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Tambah Lab/Workshop</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label fw-bold">Pilih Prodi</label>
                        <select name="prodi" class="form-select" required>
                            <option value="">-- Pilih Prodi --</option>
                            <option value="TPK">TPK</option>
                            <option value="TPPK">TPPK</option>
                            <option value="TPKP">TPKP</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-bold">Nama Lab / Workshop</label>
                        <input type="text" name="nama_lab" class="form-control" placeholder="Ketik Manual Nama lab / Workshop" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary px-4">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection