<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4" style="background-color: #f8fafc; min-height: 100vh;">
    
    <div class="d-flex align-items-center justify-content-between mb-4">
        <div>
            <h3 class="fw-bold text-dark mb-1">Preventive Maintenance (Kalibrasi)</h3>
            <p class="text-muted small mb-0">Pemantauan jadwal kalibrasi alat untuk akurasi pengujian laboratorium.</p>
        </div>
        <div class="bg-white border rounded-pill px-3 py-2 shadow-sm small">
            <i class="bi bi-calendar-event me-2 text-primary"></i> 
            Hari Ini: <strong><?php echo e(now()->translatedFormat('d F Y')); ?></strong>
        </div>
    </div>

    <div class="card shadow-sm border-0 rounded-4 overflow-hidden bg-white">
        <div class="card-header bg-white py-3 border-bottom">
            <h6 class="m-0 fw-bold text-primary"><i class="bi bi-clock-history me-2"></i>Monitoring Masa Kalibrasi Alat</h6>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="bg-light text-muted small text-uppercase">
                        <tr>
                            <th class="ps-4 py-3">No</th>
                            <th>Informasi Alat</th>
                            <th>Unit Kerja</th>
                            <th class="text-center">Jadwal Kalibrasi</th>
                            <th class="text-center">Sisa Waktu</th>
                            <th class="text-center">Status</th>
                            <th class="pe-4 text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $needs_calibration; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php
                            $nextCal = \Carbon\Carbon::parse($item->next_calibration);
                            $daysLeft = now()->diffInDays($nextCal, false);
                            
                            // Menentukan warna berdasarkan sisa hari
                            $statusColor = 'success';
                            if($daysLeft < 0) $statusColor = 'danger';
                            elseif($daysLeft <= 30) $statusColor = 'warning';
                        ?>
                        <tr>
                            <td class="ps-4 text-muted"><?php echo e($index + 1); ?></td>
                            <td>
                                <div class="fw-bold text-dark"><?php echo e($item->nama_barang); ?></div>
                                <div class="small text-muted font-monospace" style="font-size: 11px;"><?php echo e($item->kode_bmn); ?></div>
                            </td>
                            <td>
                                <span class="badge bg-light text-primary border rounded-pill">
                                    <?php echo e($item->lab->nama_lab ?? '-'); ?>

                                </span>
                            </td>
                            <td class="text-center">
                                <div class="fw-bold"><?php echo e($nextCal->format('d/m/Y')); ?></div>
                                <div class="text-muted" style="font-size: 10px;"><?php echo e($nextCal->diffForHumans()); ?></div>
                            </td>
                            <td class="text-center">
                                <div class="fw-bold text-<?php echo e($statusColor); ?>">
                                    <?php if($daysLeft < 0): ?>
                                        Terlambat <?php echo e(abs($daysLeft)); ?> Hari
                                    <?php else: ?>
                                        <?php echo e($daysLeft); ?> Hari Lagi
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td class="text-center">
                                <div class="d-inline-flex align-items-center px-3 py-1 rounded-pill bg-<?php echo e($statusColor); ?> bg-opacity-10 text-<?php echo e($statusColor); ?> fw-bold" style="font-size: 10px; border: 1px solid rgba(var(--bs-<?php echo e($statusColor); ?>-rgb), 0.2);">
                                    <?php if($daysLeft < 0): ?>
                                        <i class="bi bi-exclamation-triangle-fill me-1"></i> OVERDUE
                                    <?php elseif($daysLeft <= 30): ?>
                                        <i class="bi bi-hourglass-split me-1"></i> NEAR DUE
                                    <?php else: ?>
                                        <i class="bi bi-check-circle-fill me-1"></i> SAFE
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td class="pe-4 text-center">
                                
                                <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-sm btn-primary rounded-pill px-3 fw-bold shadow-sm transition-all hover-lift">
                                    <i class="bi bi-plus-lg me-1"></i> Buat Ajuan
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center py-5">
                                <img src="https://cdn-icons-png.flaticon.com/512/1548/1548682.png" width="80" class="mb-3 opacity-25">
                                <p class="text-muted fw-medium">Seluruh alat di unit kerja Anda dalam kondisi terkalibrasi.</p>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<style>
    .hover-lift:hover { transform: translateY(-2px); }
    .transition-all { transition: all 0.3s ease; }
    .table thead th { font-size: 11px; letter-spacing: 0.5px; }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\maintanance-lab\maintenance-lab\resources\views/kaprodi/calibration.blade.php ENDPATH**/ ?>