<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4" style="background-color: #f8fafc; min-height: 100vh;">
    
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="fw-bold text-dark mb-1">Dashboard Monitoring</h2>
            <p class="text-muted small mb-0">Pemantauan realisasi maintenance alat di lingkungan Program Studi.</p>
        </div>
        <div class="text-end">
            <span class="badge bg-primary px-3 py-2 rounded-pill shadow-sm">
                <i class="bi bi-building me-1"></i> Prodi ID: <?php echo e(Auth::user()->prodi_id); ?>

            </span>
        </div>
    </div>

    
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show rounded-4 shadow-sm mb-4 border-0 p-3" role="alert" style="background: #ecfdf5;">
            <div class="d-flex align-items-center">
                <i class="bi bi-check-circle-fill text-success fs-4 me-3"></i>
                <div class="text-success fw-medium"><?php echo e(session('success')); ?></div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    
    <div class="card mb-4 shadow-sm border-0 rounded-4">
        <div class="card-body p-4">
            <form action="<?php echo e(route('kaprodi.dashboard')); ?>" method="GET" class="row g-3">
                <div class="col-md-3">
                    <label class="form-label fw-bold small text-muted text-uppercase" style="font-size: 10px;">Filter Unit Lab</label>
                    <select name="lab_id" class="form-select border-2 rounded-3 shadow-none">
                        <option value="">Semua Lab Prodi</option>
                        <?php $__currentLoopData = $labs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lab): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($lab->id); ?>" <?php echo e(request('lab_id') == $lab->id ? 'selected' : ''); ?>>
                                <?php echo e($lab->nama_lab); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="col-md-4">
                    <label class="form-label fw-bold small text-muted text-uppercase" style="font-size: 10px;">Rentang Waktu Pengajuan</label>
                    <div class="input-group">
                        <input type="date" name="start_date" class="form-control border-2 rounded-start-3 shadow-none" value="<?php echo e(request('start_date')); ?>">
                        <span class="input-group-text border-2 bg-light text-muted small">s/d</span>
                        <input type="date" name="end_date" class="form-control border-2 rounded-end-3 shadow-none" value="<?php echo e(request('end_date')); ?>">
                    </div>
                </div>

                <div class="col-md-3">
                    <label class="form-label fw-bold small text-muted text-uppercase" style="font-size: 10px;">Status Tiket</label>
                    <select name="status" class="form-select border-2 rounded-3 shadow-none">
                        <option value="">Semua Status</option>
                        <option value="pending_kaprodi" <?php echo e(request('status') == 'pending_kaprodi' ? 'selected' : ''); ?>>Menunggu Saya</option>
                        <option value="repairing" <?php echo e(request('status') == 'repairing' ? 'selected' : ''); ?>>Proses Perbaikan</option>
                        <option value="closed" <?php echo e(request('status') == 'closed' ? 'selected' : ''); ?>>Selesai (Closed)</option>
                    </select>
                </div>

                <div class="col-md-2 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100 rounded-3 shadow-sm py-2 fw-bold transition-all hover-lift">
                        <i class="bi bi-funnel-fill me-1"></i> Filter
                    </button>
                </div>
            </form>
        </div>
    </div>

    
    <div class="row mb-4 g-3">
        <?php
            $kpis = [
                ['label' => 'Total Ajuan', 'val' => $stats['total'], 'bg' => 'primary', 'icon' => 'bi-collection-fill'],
                ['label' => 'Menunggu Saya', 'val' => $stats['pending'], 'bg' => 'warning', 'icon' => 'bi-shield-exclamation'],
                ['label' => 'Proses Perbaikan', 'val' => $stats['on_progress'], 'bg' => 'info', 'icon' => 'bi-gear-wide-connected'],
                ['label' => 'Selesai (Closed)', 'val' => $stats['closed'], 'bg' => 'success', 'icon' => 'bi-check-circle-fill'],
            ];
        ?>
        <?php $__currentLoopData = $kpis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kpi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-md-3">
            <div class="card bg-<?php echo e($kpi['bg']); ?> text-<?php echo e($kpi['bg'] == 'warning' ? 'dark' : 'white'); ?> shadow-sm border-0 rounded-4 transition-all hover-lift">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="bg-white bg-opacity-25 rounded-3 p-2">
                            <i class="bi <?php echo e($kpi['icon']); ?> fs-4"></i>
                        </div>
                        <h2 class="fw-bold mb-0"><?php echo e($kpi['val']); ?></h2>
                    </div>
                    <h6 class="opacity-75 small text-uppercase fw-bold mb-0"><?php echo e($kpi['label']); ?></h6>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    
    <div class="card shadow-sm border-0 rounded-4 overflow-hidden bg-white">
        <div class="card-header bg-white py-4 px-4 border-bottom">
            <h5 class="mb-0 fw-bold text-dark">Laporan Realisasi Maintenance</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="bg-light">
                        <tr class="text-uppercase small fw-bold text-muted" style="font-size: 11px;">
                            <th class="ps-4 py-3">No</th>
                            <th>Tanggal & Waktu</th>
                            <th>Aset / Alat</th>
                            <th>Laboratorium</th>
                            <th>Progress Status</th>
                            <th class="text-center pe-4">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="border-top-0">
                        <?php $__empty_1 = true; $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $req): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="ps-4 fw-medium text-muted"><?php echo e($requests->firstItem() + $key); ?></td>
                            <td>
                                <div class="fw-bold text-dark"><?php echo e($req->created_at->format('d/m/Y')); ?></div>
                                <div class="text-muted" style="font-size: 10px;"><?php echo e($req->created_at->format('H:i')); ?> WIB</div>
                            </td>
                            <td>
                                
                                <div class="fw-bold text-primary"><?php echo e($req->barang?->nama_barang ?? 'Alat Tidak Ditemukan'); ?></div>
                                <div class="badge bg-light text-muted border py-1 px-2 mt-1 font-monospace" style="font-size: 9px;">
                                    <i class="bi bi-hash"></i><?php echo e($req->barang?->kode_bmn ?? '-'); ?>

                                </div>
                            </td>
                            <td>
                                <span class="badge bg-light text-dark border p-2 fw-medium">
                                    <i class="bi bi-geo-alt-fill text-danger me-1"></i>
                                    <?php echo e($req->lab?->nama_lab ?? 'Lab N/A'); ?>

                                </span>
                            </td>
                            <td>
                                <?php
                                    $statusConfig = [
                                        'pending_kaprodi' => ['color' => 'warning', 'icon' => 'bi-shield-exclamation', 'label' => 'Menunggu Kaprodi'],
                                        'repairing' => ['color' => 'primary', 'icon' => 'bi-tools', 'label' => 'Proses Perbaikan'],
                                        'closed' => ['color' => 'success', 'icon' => 'bi-check-all', 'label' => 'Selesai'],
                                        'default' => ['color' => 'secondary', 'icon' => 'bi-info-circle', 'label' => $req->status]
                                    ];
                                    $st = $statusConfig[$req->status] ?? $statusConfig['default'];
                                ?>
                                <div class="d-inline-flex align-items-center px-3 py-1 rounded-pill bg-<?php echo e($st['color']); ?> bg-opacity-10 text-<?php echo e($st['color']); ?> fw-bold" style="font-size: 10px; border: 1px solid rgba(var(--bs-<?php echo e($st['color']); ?>-rgb), 0.2);">
                                    <i class="<?php echo e($st['icon']); ?> me-1"></i> <?php echo e(strtoupper($st['label'])); ?>

                                </div>
                            </td>
                            <td class="text-center pe-4">
                                <?php echo $__env->make('layouts.actions', ['item' => $req], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center py-5">
                                <img src="https://cdn-icons-png.flaticon.com/512/7486/7486744.png" width="80" class="mb-3 opacity-25">
                                <p class="text-muted small">Tidak ada data pengajuan yang ditemukan.</p>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="p-4 border-top">
                <?php echo e($requests->links()); ?>

            </div>
        </div>
    </div>
</div>

<style>
    .hover-lift:hover { transform: translateY(-3px); }
    .transition-all { transition: all 0.3s ease; }
    .table thead th { font-weight: 700; letter-spacing: 0.5px; }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\maintanance-lab\maintenance-lab\resources\views/kaprodi/dashboard.blade.php ENDPATH**/ ?>