<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <div class="d-flex align-items-center justify-content-between mb-4">
        <div>
            <h3 class="text-white fw-bold mb-1">Lab Readiness Index</h3>
            <p class="text-white-50 small mb-0">Kesiapan Infrastruktur Laboratorium untuk KBM</p>
        </div>
        <div class="bg-glass text-white px-3 py-2 rounded-pill small">
            <i class="fas fa-microscope me-2"></i> Total: <?php echo e($readiness->count()); ?> Lab
        </div>
    </div>

    <div class="row">
        <?php $__currentLoopData = $readiness; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lab): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php 
                $persen = $lab->total_alat > 0 ? round(($lab->alat_siap / $lab->total_alat) * 100) : 0;
                // Menentukan warna berdasarkan persentase
                $colorClass = $persen >= 80 ? 'success' : ($persen >= 50 ? 'warning' : 'danger');
            ?>
            
            <div class="col-xl-4 col-md-6 mb-4">
                <div class="card border-0 shadow-sm rounded-4 h-100">
                    <div class="card-body p-4">
                        <div class="d-flex justify-content-between align-items-start mb-3">
                            <div>
                                <h5 class="fw-bold text-dark mb-1"><?php echo e($lab->nama_lab); ?></h5>
                                <span class="text-muted small">ID Lab: #<?php echo e($lab->id); ?></span>
                            </div>
                            <span class="badge bg-<?php echo e($colorClass); ?>-subtle text-<?php echo e($colorClass); ?> px-3 py-2 rounded-pill">
                                <?php echo e($persen); ?>% Siap
                            </span>
                        </div>

                        <div class="mb-4">
                            <div class="d-flex justify-content-between small mb-2">
                                <span class="text-muted">Status Kesiapan Alat</span>
                                <span class="fw-bold"><?php echo e($lab->alat_siap); ?> / <?php echo e($lab->total_alat); ?> Unit</span>
                            </div>
                            <div class="progress rounded-pill" style="height: 10px;">
                                <div class="progress-bar bg-<?php echo e($colorClass); ?> shadow-none" 
                                     role="progressbar" 
                                     style="width: <?php echo e($persen); ?>%" 
                                     aria-valuenow="<?php echo e($persen); ?>" 
                                     aria-valuemin="0" 
                                     aria-valuemax="100">
                                </div>
                            </div>
                        </div>

                        <div class="row text-center border-top pt-3">
                            <div class="col-6 border-end">
                                <p class="text-muted small mb-0">Normal</p>
                                <h6 class="fw-bold text-success mb-0"><?php echo e($lab->alat_siap); ?></h6>
                            </div>
                            <div class="col-6">
                                <p class="text-muted small mb-0">Bermasalah</p>
                                <h6 class="fw-bold text-danger mb-0"><?php echo e($lab->total_alat - $lab->alat_siap); ?></h6>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>

<style>
    .bg-glass {
        background: rgba(255, 255, 255, 0.15);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.2);
    }
    .card { transition: transform 0.2s ease; }
    .card:hover { transform: translateY(-5px); }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\maintanance-lab\maintenance-lab\resources\views/admin/pudir1/readiness.blade.php ENDPATH**/ ?>