<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4" style="background-color: #f1f5f9; min-height: 100vh;">
    
    
    <div class="d-flex align-items-center justify-content-between mb-5">
        <div>
            <h2 class="fw-extrabold text-slate-800 mb-1" style="letter-spacing: -0.5px;">Antrean Persetujuan Anggaran</h2>
            <p class="text-slate-500 small mb-0">Tinjau dan validasi estimasi biaya perbaikan alat dari seluruh laboratorium.</p>
        </div>
        <div class="d-flex gap-3">
            <div class="bg-indigo-600 text-white px-4 py-2 rounded-4 shadow-sm d-flex align-items-center transition-all hover-lift">
                <i class="bi bi-wallet2 me-2"></i>
                <span class="small fw-bold">Total Antrean: <?php echo e($approvalQueue->total()); ?></span>
            </div>
        </div>
    </div>

    <div class="card border-0 shadow-sm rounded-4 overflow-hidden bg-white">
        <div class="card-header bg-white p-4 border-0">
            <div class="d-flex align-items-center justify-content-between">
                <h5 class="fw-bold text-slate-800 mb-0">Daftar Tunggu Validasi</h5>
                <span class="badge bg-slate-100 text-slate-600 rounded-pill px-3 py-2 border small fw-medium">
                    <i class="bi bi-funnel me-1"></i> Status: Pending Pudir 2
                </span>
            </div>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="bg-slate-50 border-top">
                        <tr class="text-slate-400 small fw-bold text-uppercase" style="letter-spacing: 1px;">
                            <th class="ps-4 py-3 border-0">Informasi Alat & Lokasi</th>
                            <th class="border-0">Metode & Estimasi Biaya</th>
                            <th class="border-0" style="width: 30%;">Rekomendasi Teknis</th>
                            <th class="text-center pe-4 border-0">Keputusan</th>
                        </tr>
                    </thead>
                    <tbody class="border-top-0">
                        <?php $__empty_1 = true; $__currentLoopData = $approvalQueue; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="ps-4 py-4">
                                <div class="fw-bold text-slate-800"><?php echo e($item->barang?->nama_barang ?? 'Unknown Asset'); ?></div>
                                <div class="text-slate-400 small d-flex align-items-center mt-1">
                                    <i class="bi bi-geo-alt-fill me-1 text-primary"></i>
                                    <?php echo e($item->lab->nama_lab ?? ($item->barang?->lab?->nama_lab ?? 'Unit N/A')); ?>

                                </div>
                            </td>
                            <td>
                                <div class="fw-extrabold text-primary fs-5 mb-1">
                                    Rp <?php echo e(number_format($item->estimated_cost, 0, ',', '.')); ?>

                                </div>
                                <?php
                                    $isExternal = $item->repair_type == 'External';
                                ?>
                                <span class="badge rounded-pill fw-bold <?php echo e($isExternal ? 'bg-amber-100 text-amber-700' : 'bg-indigo-100 text-indigo-700'); ?>" style="font-size: 10px;">
                                    <i class="bi <?php echo e($isExternal ? 'bi-truck' : 'bi-person-badge'); ?> me-1"></i>
                                    <?php echo e(strtoupper($item->repair_type)); ?>

                                </span>
                            </td>
                            <td>
                                <div class="p-3 bg-light rounded-4 small text-slate-600 border-start border-primary border-4">
                                    <i class="bi bi-chat-left-quote-fill me-2 opacity-25"></i>
                                    <?php echo e(Str::limit($item->technical_recommendation ?? 'Tidak ada catatan teknis tambahan.', 100)); ?>

                                </div>
                            </td>
                            <td class="text-center pe-4">
                                <div class="d-flex justify-content-center gap-2">
                                    
                                    <form action="<?php echo e(route('maintenance.approve.pudir2', $item->id)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-success rounded-pill px-4 fw-bold small shadow-sm transition-all hover-lift">
                                            <i class="bi bi-check-lg me-1"></i> Setuju
                                        </button>
                                    </form>
                                    
                                    <button class="btn btn-outline-danger rounded-pill px-4 fw-bold small shadow-sm transition-all hover-lift" 
                                            data-bs-toggle="modal" 
                                            data-bs-target="#rejectModal<?php echo e($item->id); ?>">
                                        <i class="bi bi-x-lg me-1"></i> Tolak
                                    </button>
                                </div>
                            </td>
                        </tr>

                        
                        <div class="modal fade" id="rejectModal<?php echo e($item->id); ?>" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered">
                                <div class="modal-content border-0 shadow-lg rounded-4">
                                    <form action="<?php echo e(route('maintenance.reject', $item->id)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <div class="modal-header border-0 p-4">
                                            <h5 class="modal-title fw-extrabold text-slate-800">Alasan Penolakan</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body px-4 py-0">
                                            <div class="bg-light p-3 rounded-4 mb-4">
                                                <small class="text-muted d-block mb-1">Aset Terkait:</small>
                                                <span class="fw-bold text-slate-700"><?php echo e($item->barang?->nama_barang); ?></span>
                                            </div>
                                            <label class="form-label small fw-bold text-slate-400 text-uppercase">Catatan Pudir 2</label>
                                            <textarea name="note" class="form-control rounded-4 border-2 p-3 shadow-none" rows="4" placeholder="Berikan alasan logis penolakan anggaran..." required></textarea>
                                        </div>
                                        <div class="modal-footer border-0 p-4">
                                            <button type="button" class="btn btn-light rounded-pill px-4 fw-bold" data-bs-dismiss="modal">Batal</button>
                                            <button type="submit" class="btn btn-danger rounded-pill px-4 fw-bold shadow">Kirim Penolakan</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="4" class="text-center py-5">
                                <div class="bg-light rounded-circle d-inline-flex p-4 mb-3">
                                    <i class="bi bi-check-all fs-1 text-success"></i>
                                </div>
                                <h6 class="fw-bold text-slate-800">Antrean Bersih</h6>
                                <p class="text-slate-400 small">Tidak ada permintaan persetujuan biaya saat ini.</p>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php if($approvalQueue->hasPages()): ?>
        <div class="card-footer bg-white border-top p-4">
            <?php echo e($approvalQueue->withQueryString()->links()); ?>

        </div>
        <?php endif; ?>
    </div>
</div>

<style>
    .fw-extrabold { font-weight: 800; }
    .text-slate-800 { color: #1e293b; }
    .text-slate-600 { color: #475569; }
    .text-slate-500 { color: #64748b; }
    .text-slate-400 { color: #94a3b8; }
    .bg-slate-50 { background-color: #f8fafc; }
    .bg-amber-100 { background-color: #fef3c7; }
    .text-amber-700 { color: #b45309; }
    .bg-indigo-100 { background-color: #e0e7ff; }
    .text-indigo-700 { color: #4338ca; }
    
    .hover-lift:hover { transform: translateY(-3px); }
    .transition-all { transition: all 0.3s cubic-bezier(.4,0,.2,1); }
    
    .modal-content {
        animation: modalFadeUp 0.3s ease-out;
    }

    @keyframes modalFadeUp {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\maintanance-lab\maintenance-lab\resources\views/admin/pudir2/approval.blade.php ENDPATH**/ ?>