<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4" style="background-color: #f8fafc; min-height: 100vh;">
    
    <div class="d-flex justify-content-between align-items-center mb-4 p-4 rounded-4 shadow-sm border-0 d-print-none" style="background: linear-gradient(135deg, #1e40af 0%, #3b82f6 100%);">
        <div>
            <h2 class="text-white mb-1 fw-bold">Master Inventaris Alat</h2>
            <p class="text-white-50 mb-0"><i class="fas fa-university me-2"></i>Program Studi: <?php echo e(Auth::user()->prodi->nama_prodi ?? 'N/A'); ?></p>
        </div>
        <button class="btn btn-light rounded-pill px-4 fw-bold shadow-sm transition-all hover-lift" onclick="window.print()">
            <i class="fas fa-print me-2 text-primary"></i>Cetak Laporan Aset
        </button>
    </div>

    
    <div class="d-none d-print-block mb-4 text-center">
        <h3 class="fw-bold">DATA INVENTARIS LABORATORIUM & WORKSHOP</h3>
        <h4 class="text-uppercase">PRODI <?php echo e(Auth::user()->prodi->nama_prodi ?? ''); ?></h4>
        <p class="small text-muted">Dicetak pada: <?php echo e(now()->translatedFormat('d F Y H:i')); ?> WIB</p>
        <hr>
    </div>

    
    <div class="row g-4 mb-4 stats-row d-print-none">
        <div class="col-md-4">
            <div class="card border-0 shadow-sm rounded-4 text-white" style="background-color: #15803d;">
                <div class="card-body p-4 text-center">
                    <i class="fas fa-check-double fa-2x mb-2"></i>
                    <h6 class="fw-bold opacity-75 small">SIAP PAKAI</h6>
                    <h2 class="mb-0 fw-bold"><?php echo e($equipment->where('status_kondisi', 'Normal')->count()); ?> Unit</h2>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card border-0 shadow-sm rounded-4 text-white" style="background-color: #a16207;">
                <div class="card-body p-4 text-center">
                    <i class="fas fa-tools fa-2x mb-2"></i>
                    <h6 class="fw-bold opacity-75 small">MAINTENANCE</h6>
                    <h2 class="mb-0 fw-bold"><?php echo e($equipment->whereNotIn('status_kondisi', ['Normal', 'Rusak'])->count()); ?> Unit</h2>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card border-0 shadow-sm rounded-4 text-white" style="background-color: #b91c1c;">
                <div class="card-body p-4 text-center">
                    <i class="fas fa-exclamation-triangle fa-2x mb-2"></i>
                    <h6 class="fw-bold opacity-75 small">RUSAK / AFKIR</h6>
                    <h2 class="mb-0 fw-bold"><?php echo e($equipment->where('status_kondisi', 'Rusak')->count()); ?> Unit</h2>
                </div>
            </div>
        </div>
    </div>

    
    <div class="card border-0 shadow-sm rounded-4 overflow-hidden bg-white">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="bg-light">
                        <tr class="text-muted small">
                            <th class="ps-4 py-3 border-0">No</th>
                            <th class="py-3 border-0">Identitas Alat</th>
                            <th class="py-3 border-0">Spesifikasi</th>
                            <th class="py-3 border-0 text-center">Unit Lokasi</th>
                            <th class="py-3 border-0 text-center" style="width: 180px;">Kondisi</th>
                            <th class="text-center pe-4 py-3 border-0 d-print-none">Opsi</th>
                        </tr>
                    </thead>
                    <tbody class="border-top-0">
                        <?php $__empty_1 = true; $__currentLoopData = $equipment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="ps-4 text-muted small"><?php echo e($index + 1); ?></td>
                            <td>
                                <div class="fw-bold text-dark mb-0"><?php echo e($item->nama_barang ?? 'N/A'); ?></div>
                                <div class="badge bg-light text-primary border rounded-pill font-monospace" style="font-size: 10px;">
                                    <?php echo e($item->kode_bmn ?? 'Tanpa Kode'); ?>

                                </div>
                            </td>
                            <td>
                                <div class="small text-dark">Merk: <span class="text-muted fw-medium"><?php echo e($item->merk_tipe ?? '-'); ?></span></div>
                                <div class="small text-dark">Thn: <span class="text-muted fw-medium"><?php echo e($item->tahun_perolehan ?? '-'); ?></span></div>
                            </td>
                            <td class="text-center">
                                <span class="badge bg-info bg-opacity-10 text-info px-3 py-2 border border-info border-opacity-25 rounded-pill fw-medium" style="font-size: 11px;">
                                    <i class="fas fa-door-open me-1"></i> <?php echo e($item->lab->nama_lab ?? 'Unit N/A'); ?>

                                </span>
                            </td>
                            <td class="text-center">
                                <?php
                                    $status = $item->status_kondisi;
                                    $config = [
                                        'Normal' => ['bg' => '#15803d', 'icon' => 'fa-check-circle', 'label' => 'SIAP PAKAI'],
                                        'Rusak' => ['bg' => '#b91c1c', 'icon' => 'fa-times-circle', 'label' => 'RUSAK / AFKIR'],
                                        'Maintenance' => ['bg' => '#a16207', 'icon' => 'fa-tools', 'label' => 'MAINTENANCE']
                                    ];
                                    $current = $config[$status] ?? ['bg' => '#334155', 'icon' => 'fa-question-circle', 'label' => strtoupper($status)];
                                ?>
                                <span class="badge shadow-sm px-3 py-2 w-100" 
                                      style="background-color: <?php echo e($current['bg']); ?>; color: #ffffff; border-radius: 8px; font-size: 10px; letter-spacing: 0.5px;">
                                    <i class="fas <?php echo e($current['icon']); ?> me-1"></i> <?php echo e($current['label']); ?>

                                </span>
                            </td>
                            <td class="text-center pe-4 d-print-none">
                                <a href="<?php echo e(route('kaprodi.equipment.history', $item->id)); ?>" 
                                   class="btn btn-sm btn-outline-primary rounded-pill px-3 fw-bold shadow-none transition-all hover-lift">
                                    <i class="fas fa-history me-1"></i> Riwayat
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center py-5">
                                <i class="fas fa-box-open fa-3x text-muted mb-3 opacity-25"></i>
                                <p class="text-muted">Tidak ada data alat ditemukan untuk prodi ini.</p>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>


<style>
    .hover-lift:hover { transform: translateY(-2px); }
    .transition-all { transition: all 0.2s ease-in-out; }
    .table thead th { font-weight: 700; letter-spacing: 0.5px; }
    
    @media print {
        /* Sembunyikan elemen navigasi */
        .d-print-none, .sidebar, .navbar, .btn, .stats-row { 
            display: none !important; 
        }
        /* Penyesuaian layout kertas */
        body { background: white !important; color: black !important; }
        .container-fluid { width: 100% !important; padding: 0 !important; }
        .card { box-shadow: none !important; border: 1px solid #000 !important; }
        .table { width: 100% !important; border-collapse: collapse !important; }
        .table th, .table td { border: 1px solid #000 !important; padding: 8px !important; }
        .badge { border: 1px solid #000 !important; color: #000 !important; background: none !important; }
    }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\maintanance-lab\maintenance-lab\resources\views/kaprodi/inventory.blade.php ENDPATH**/ ?>