# Website Program Studi TPPK

Website resmi Program Studi Teknologi Pengolahan Produk Kulit (TPPK) yang dibangun dengan Laravel dan Tailwind CSS.

## 🚀 Fitur Utama

### Frontend
- **Beranda**: Halaman utama dengan informasi program studi
- **Profil Prodi**: Visi & Misi, Sejarah, dan Dosen
- **Akademik**: Informasi akademik dan kurikulum
- **Berita**: Berita terkini dan artikel
- **Pengumuman**: Pengumuman resmi dan informasi penting
- **Kontak**: Informasi kontak dan lokasi

### Admin Panel
- **Dashboard**: Ringkasan statistik dan aktivitas
- **Manajemen Berita**: CRUD berita dengan status publish
- **Manajemen Pengumuman**: CRUD pengumuman dengan lampiran
- **Manajemen Profil**: Update konten profil program studi
- **Manajemen User**: Pengelolaan akun admin (Super Admin only)

## 🛠️ Teknologi

- **Backend**: Laravel 12 (PHP 8.2+)
- **Frontend**: Tailwind CSS
- **Database**: MySQL
- **Authentication**: Laravel Auth dengan role-based access control

## 📋 Persyaratan Sistem

- PHP 8.2 atau lebih tinggi
- Composer
- Node.js 18+ dan npm
- MySQL 5.7+ atau MariaDB 10.0+
- Git

## ⚙️ Instalasi

1. **Clone Repository**
   ```bash
   git clone <repository-url>
   cd tppk-new
   ```

2. **Install Dependencies**
   ```bash
   composer install
   npm install
   ```

3. **Konfigurasi Environment**
   ```bash
   cp .env.example .env
   php artisan key:generate
   ```

   Edit file `.env`:
   ```env
   APP_NAME="TPPK - Teknologi Pengolahan Produk Kulit"
   APP_ENV=local
   APP_DEBUG=true
   APP_URL=http://localhost:8000

   DB_CONNECTION=mysql
   DB_HOST=127.0.0.1
   DB_PORT=3306
   DB_DATABASE=tppk
   DB_USERNAME=root
   DB_PASSWORD=
   ```

4. **Setup Database**
   ```bash
   # Buat database 'tppk' di MySQL
   php artisan migrate
   php artisan db:seed
   ```

5. **Build Assets**
   ```bash
   npm run build
   ```

6. **Jalankan Server**
   ```bash
   php artisan serve
   ```

   Akses website di: http://localhost:8000

## 👤 Akun Admin Default

### Super Admin
- **Email**: admin@tppk.ac.id
- **Password**: password
- **Role**: Super Admin (full access)

### Admin
- **Email**: admin2@tppk.ac.id
- **Password**: password
- **Role**: Admin (limited access)

## 🔐 Keamanan

- Password hashing menggunakan bcrypt/argon2
- CSRF protection pada semua form
- Rate limiting pada login
- Session regeneration setelah login
- Role-based access control
- Input validation yang ketat
- Route protection untuk admin area

## 📁 Struktur Direktori

```
tppk-new/
├── app/
│   ├── Http/
│   │   ├── Controllers/
│   │   │   ├── Admin/          # Admin controllers
│   │   │   └── Frontend/       # Frontend controllers
│   │   └── Middleware/         # Custom middleware
│   └── Models/                 # Eloquent models
├── database/
│   ├── migrations/             # Database migrations
│   └── seeders/               # Database seeders
├── public/                    # Public assets
├── resources/
│   ├── css/                   # Stylesheets
│   ├── js/                    # JavaScript
│   └── views/                 # Blade templates
│       ├── layouts/           # Layout templates
│       ├── admin/             # Admin views
│       └── frontend/          # Frontend views
└── routes/
    └── web.php                # Web routes
```

## 🎨 Desain

- **Warna Utama**: Biru (#2563eb)
- **Warna Aksen**: Kuning (#eab308)
- **Typography**: Instrument Sans
- **Layout**: Responsive (Mobile-First)
- **Style**: Modern dan akademik

## 📝 Penggunaan Admin Panel

### Akses Admin Panel
1. Akses admin panel di: `http://localhost:8000/admin/login`
2. Login dengan akun admin yang tersedia

### Role & Permissions
- **Super Admin**: Full access ke semua fitur
- **Admin**: Access terbatas (tidak bisa kelola user)

### Menu Admin Panel

#### 📊 Dashboard
- Ringkasan statistik berita, pengumuman
- Daftar konten terbaru
- Quick actions untuk membuat konten baru

#### 📰 Kelola Berita
- **Index**: List semua berita dengan search & filter (published/draft)
- **Create**: Form tambah berita baru dengan upload gambar
- **Edit**: Update berita existing
- **Show**: Preview detail berita
- **Delete**: Hapus berita dengan konfirmasi

#### 📢 Kelola Pengumuman
- **Index**: List semua pengumuman dengan search & filter
- **Create**: Form tambah pengumuman dengan upload lampiran (PDF/DOC)
- **Edit**: Update pengumuman existing
- **Show**: Preview detail pengumuman dengan download lampiran
- **Delete**: Hapus pengumuman dengan konfirmasi

#### 👥 Kelola Profil Prodi
- **Index**: List konten profil berdasarkan section (visi_misi, sejarah, dosen)
- **Create**: Tambah konten baru dengan section tertentu
- **Edit**: Update konten existing
- **Show**: Preview detail konten
- **Delete**: Hapus konten dengan konfirmasi
- **Filter**: Berdasarkan section dan status (active/inactive)

#### 👤 Kelola User (Super Admin Only)
- **Index**: List semua user admin dengan search & filter role
- **Create**: Tambah user admin baru
- **Edit**: Update informasi user (kecuali Super Admin)
- **Show**: Detail informasi user
- **Delete**: Hapus user (tidak bisa hapus Super Admin atau diri sendiri)

### File Upload
- **Gambar**: JPG, PNG, GIF (max 2MB) - untuk berita dan profil
- **Lampiran**: PDF, DOC, DOCX (max 5MB) - untuk pengumuman
- File disimpan di `storage/app/public/` dengan symbolic link ke `public/storage/`

### Security Features
- Role-based access control
- CSRF protection pada semua form
- Input validation lengkap
- File upload validation
- Session management aman

## 🔧 Development Commands

```bash
# Jalankan server development
php artisan serve

# Watch file changes
npm run dev

# Build untuk production
npm run build

# Jalankan migration
php artisan migrate

# Jalankan seeder
php artisan db:seed

# Clear cache
php artisan cache:clear
php artisan config:clear
php artisan view:clear
```

## 📄 Lisensi

Proyek ini dibuat untuk keperluan akademik dan internal kampus.

## 👥 Kontributor

- Developer: AI Assistant
- Institusi: Program Studi TPPK

## 📞 Dukungan

Untuk pertanyaan atau dukungan teknis, hubungi tim IT kampus.