<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Announcement;
use Illuminate\Http\Request;

class AnnouncementController extends Controller
{
    /**
     * Display a listing of announcements.
     */
    public function index()
    {
        $announcements = Announcement::published()
            ->latest('published_at')
            ->paginate(12);

        return view('frontend.pengumuman.index', compact('announcements'));
    }

    /**
     * Display the specified announcement.
     */
    public function show(Announcement $announcement)
    {
        // Ensure only published announcements can be viewed
        if (!$announcement->is_published) {
            abort(404);
        }

        // Get related announcements
        $relatedAnnouncements = Announcement::published()
            ->where('id', '!=', $announcement->id)
            ->latest('published_at')
            ->take(4)
            ->get();

        return view('frontend.pengumuman.show', compact('announcement', 'relatedAnnouncements'));
    }
}
