<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\News;
use App\Models\Announcement;
use App\Models\Profile;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Show the home page.
     */
    public function index()
    {
        // Get latest published news
        $latestNews = News::published()
            ->latest('published_at')
            ->take(6)
            ->get();

        // Get latest published announcements
        $latestAnnouncements = Announcement::published()
            ->latest('published_at')
            ->take(3)
            ->get();

        // Get profile content for homepage
        $profileContent = Profile::active()
            ->where('section', 'visi_misi')
            ->first();

        return view('frontend.home', compact('latestNews', 'latestAnnouncements', 'profileContent'));
    }
}
