<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\News;
use Illuminate\Http\Request;

class NewsController extends Controller
{
    /**
     * Display a listing of news.
     */
    public function index()
    {
        $news = News::published()
            ->latest('published_at')
            ->paginate(12);

        return view('frontend.berita.index', compact('news'));
    }

    /**
     * Display the specified news.
     */
    public function show(News $news)
    {
        // Ensure only published news can be viewed
        if (!$news->is_published) {
            abort(404);
        }

        // Get related news
        $relatedNews = News::published()
            ->where('id', '!=', $news->id)
            ->latest('published_at')
            ->take(4)
            ->get();

        return view('frontend.berita.show', compact('news', 'relatedNews'));
    }
}
