<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SampleContentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $admin = \App\Models\User::where('role', 'super_admin')->first();

        // Create sample news
        \App\Models\News::create([
            'title' => 'Selamat Datang di Website Program Studi TPPK',
            'slug' => 'selamat-datang-website-program-studi-tppk',
            'content' => '<p>Selamat datang di website resmi Program Studi Teknologi Pengolahan Produk Kulit (TPPK). Website ini merupakan sumber informasi utama mengenai program studi kami.</p>

            <h3>Apa yang bisa Anda temukan di sini?</h3>
            <ul>
                <li>Informasi lengkap tentang program studi</li>
                <li>Berita terkini seputar kegiatan akademik</li>
                <li>Pengumuman penting untuk mahasiswa</li>
                <li>Profil dosen dan tenaga pengajar</li>
                <li>Informasi akademik dan kurikulum</li>
            </ul>

            <p>Kami berkomitmen untuk memberikan pengalaman belajar yang berkualitas dan mempersiapkan lulusan yang siap bersaing di dunia kerja.</p>',
            'is_published' => true,
            'published_at' => now(),
            'user_id' => $admin->id,
        ]);

        \App\Models\News::create([
            'title' => 'Workshop Teknologi Kulit Modern',
            'slug' => 'workshop-teknologi-kulit-modern',
            'content' => '<p>Program Studi TPPK mengadakan workshop teknologi kulit modern yang menghadirkan para ahli dari industri kulit nasional.</p>

            <p>Workshop ini bertujuan untuk memberikan wawasan terkini tentang perkembangan teknologi pengolahan kulit serta praktik-praktik terbaik di industri.</p>

            <h3>Materi Workshop:</h3>
            <ul>
                <li>Teknologi tanning modern</li>
                <li>Inovasi dalam finishing kulit</li>
                <li>Kualitas dan standar produk kulit</li>
                <li>Tren pasar kulit global</li>
            </ul>',
            'is_published' => true,
            'published_at' => now()->subDays(3),
            'user_id' => $admin->id,
        ]);

        // Create sample announcements
        \App\Models\Announcement::create([
            'title' => 'Pendaftaran Mahasiswa Baru Semester Genap 2024/2025',
            'slug' => 'pendaftaran-mahasiswa-baru-semester-genap-2024-2025',
            'content' => '<p>Pendaftaran mahasiswa baru Program Studi TPPK untuk semester genap tahun akademik 2024/2025 telah dibuka.</p>

            <p><strong>Persyaratan:</strong></p>
            <ul>
                <li>Ijazah SMA/SMK sederajat</li>
                <li>Raport semester 1-5</li>
                <li>Foto 3x4 (2 lembar)</li>
                <li>Foto full body</li>
                <li>Surat keterangan sehat</li>
            </ul>

            <p><strong>Jadwal Pendaftaran:</strong><br>
            1 Januari - 31 Maret 2025</p>

            <p>Informasi lebih lanjut dapat diperoleh di bagian akademik atau website resmi kampus.</p>',
            'is_published' => true,
            'published_at' => now()->subDays(1),
            'user_id' => $admin->id,
        ]);

        \App\Models\Announcement::create([
            'title' => 'Pengumuman Hasil Seleksi Beasiswa Semester Genap',
            'slug' => 'pengumuman-hasil-seleksi-beasiswa-semester-genap',
            'content' => '<p>Hasil seleksi beasiswa untuk semester genap tahun akademik 2024/2025 telah diumumkan.</p>

            <p>Daftar nama penerima beasiswa dapat dilihat pada lampiran atau di papan pengumuman program studi.</p>

            <p>Selamat kepada mahasiswa yang lolos seleksi. Tetap semangat dan jaga prestasi akademik!</p>

            <p><strong>Catatan:</strong> Beasiswa dapat dicabut jika terjadi pelanggaran tata tertib kampus.</p>',
            'is_published' => true,
            'published_at' => now()->subDays(5),
            'user_id' => $admin->id,
        ]);

        // Create sample profile content
        \App\Models\Profile::create([
            'section' => 'visi_misi',
            'title' => 'Visi Program Studi TPPK',
            'content' => '<h3>Visi</h3>
            <p>Menjadi program studi unggul dalam bidang teknologi pengolahan produk kulit yang berdaya saing global dan berkontribusi pada pembangunan industri kulit nasional.</p>

            <h3>Misi</h3>
            <ol>
                <li>Menyelenggarakan pendidikan tinggi yang bermutu dalam bidang teknologi pengolahan produk kulit</li>
                <li>Mengembangkan penelitian yang inovatif dan aplikatif di bidang teknologi kulit</li>
                <li>Melaksanakan pengabdian kepada masyarakat melalui transfer teknologi dan konsultasi</li>
                <li>Menjalin kemitraan dengan industri kulit untuk pengembangan kurikulum dan praktikum</li>
                <li>Mencetak lulusan yang kompeten, profesional, dan berakhlak mulia</li>
            </ol>',
            'order' => 1,
            'is_active' => true,
        ]);

        \App\Models\Profile::create([
            'section' => 'sejarah',
            'title' => 'Sejarah Program Studi TPPK',
            'content' => '<p>Program Studi Teknologi Pengolahan Produk Kulit (TPPK) didirikan pada tahun 2010 sebagai respon terhadap kebutuhan industri kulit nasional akan tenaga ahli yang kompeten.</p>

            <p>Sejak awal berdiri, program studi ini telah berkomitmen untuk menghasilkan lulusan yang tidak hanya memiliki kompetensi teknis yang tinggi, tetapi juga memiliki etika kerja yang profesional.</p>

            <p>Dalam perjalanannya, TPPK telah mengalami berbagai perkembangan, mulai dari sarana prasarana laboratorium, kurikulum yang selalu diperbaharui sesuai perkembangan teknologi, hingga kemitraan dengan berbagai perusahaan kulit terkemuka.</p>',
            'order' => 1,
            'is_active' => true,
        ]);

        \App\Models\Profile::create([
            'section' => 'dosen',
            'title' => 'Dosen Tetap Program Studi TPPK',
            'content' => '<h3>Ketua Program Studi</h3>
            <p><strong>Dr. Ir. Ahmad Suryanto, M.Sc.</strong><br>
            Ahli di bidang teknologi kulit dan pengawetan kulit</p>

            <h3>Dosen Tetap</h3>
            <ul>
                <li>Prof. Dr. Siti Nurhaliza, M.T. - Teknologi Finishing Kulit</li>
                <li>Dr. Budi Santoso, M.Sc. - Kimia Kulit dan Bahan Tambahan</li>
                <li>Ir. Rina Sari, M.T. - Teknologi Pengolahan Kulit</li>
                <li>Dra. Maya Indah, M.Sc. - Analisis dan Pengendalian Kualitas</li>
                <li>Ir. Hendro Wibowo, M.T. - Teknologi Lingkungan Industri Kulit</li>
            </ul>

            <h3>Dosen Luar Biasa</h3>
            <ul>
                <li>Ir. Bambang Pramono - Praktisi Industri Kulit PT. XYZ</li>
                <li>Dra. Sari Dewi - Quality Control Manager PT. ABC Leather</li>
            </ul>',
            'order' => 1,
            'is_active' => true,
        ]);
    }
}
