<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SliderSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        \App\Models\Slider::create([
            'title' => 'Program Studi Teknologi Pengolahan Produk Kulit',
            'description' => 'Mengembangkan teknologi inovatif untuk pengolahan produk kulit berkualitas tinggi dengan pendekatan akademik dan praktis profesional.',
            'image' => 'sliders/slider1.jpg', // Pastikan file ini ada di storage/app/public/sliders/
            'button_text' => 'Pelajari Lebih Lanjut',
            'button_link' => '/profil/visi-misi',
            'is_active' => true,
            'order' => 1
        ]);

        \App\Models\Slider::create([
            'title' => 'Laboratorium Modern & Fasilitas Lengkap',
            'description' => 'Fasilitas laboratorium dengan peralatan terkini untuk praktikum dan penelitian di bidang teknologi pengolahan kulit.',
            'image' => 'sliders/slider2.jpg',
            'button_text' => 'Lihat Fasilitas',
            'button_link' => '/akademik',
            'is_active' => true,
            'order' => 2
        ]);

        \App\Models\Slider::create([
            'title' => 'Bersama Mencapai Kesuksesan',
            'description' => 'Bergabunglah dengan komunitas akademik TPPK untuk mengembangkan potensi dan meraih karier di industri kulit.',
            'image' => 'sliders/slider3.jpg',
            'button_text' => 'Hubungi Kami',
            'button_link' => '/kontak',
            'is_active' => true,
            'order' => 3
        ]);
    }
}
