@extends('layouts.admin')

@section('page-title', 'Tambah Pengumuman Baru')
@section('page-subtitle', 'Buat pengumuman baru untuk program studi')

@section('content')
<div class="max-w-4xl mx-auto">
    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-4 border-b border-gray-200">
            <h1 class="text-xl font-semibold text-gray-900">Tambah Pengumuman Baru</h1>
        </div>

        <form action="{{ route('admin.announcements.store') }}" method="POST" enctype="multipart/form-data" class="p-6 space-y-6">
            @csrf

            <!-- Title -->
            <div>
                <label for="title" class="block text-sm font-medium text-gray-700 mb-2">
                    Judul Pengumuman <span class="text-red-500">*</span>
                </label>
                <input type="text" name="title" id="title" value="{{ old('title') }}"
                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-yellow-500 focus:border-yellow-500 @error('title') border-red-500 @enderror"
                       placeholder="Masukkan judul pengumuman" required>
                @error('title')
                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <!-- Content -->
            <div>
                <label for="content" class="block text-sm font-medium text-gray-700 mb-2">
                    Konten Pengumuman <span class="text-red-500">*</span>
                </label>
                <textarea name="content" id="content" rows="10"
                          class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-yellow-500 focus:border-yellow-500 @error('content') border-red-500 @enderror"
                          placeholder="Masukkan konten pengumuman lengkap" required>{{ old('content') }}</textarea>
                @error('content')
                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <!-- Attachment -->
            <div>
                <label for="attachment" class="block text-sm font-medium text-gray-700 mb-2">
                    Lampiran (Opsional)
                </label>
                <input type="file" name="attachment" id="attachment" accept=".pdf,.doc,.docx"
                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-yellow-500 focus:border-yellow-500 @error('attachment') border-red-500 @enderror">
                <p class="mt-1 text-sm text-gray-500">Format: PDF, DOC, DOCX. Maksimal 5MB.</p>
                @error('attachment')
                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <!-- Publication Settings -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Published Status -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Status Publikasi</label>
                    <div class="space-y-2">
                        <div class="flex items-center">
                            <input type="radio" name="is_published" id="draft" value="0" {{ old('is_published', '0') == '0' ? 'checked' : '' }}
                                   class="h-4 w-4 text-yellow-600 focus:ring-yellow-500 border-gray-300">
                            <label for="draft" class="ml-2 block text-sm text-gray-900">Draft (Simpan sebagai draft)</label>
                        </div>
                        <div class="flex items-center">
                            <input type="radio" name="is_published" id="published" value="1" {{ old('is_published') == '1' ? 'checked' : '' }}
                                   class="h-4 w-4 text-yellow-600 focus:ring-yellow-500 border-gray-300">
                            <label for="published" class="ml-2 block text-sm text-gray-900">Published (Publikasikan)</label>
                        </div>
                    </div>
                </div>

                <!-- Publish Date -->
                <div>
                    <label for="published_at" class="block text-sm font-medium text-gray-700 mb-2">
                        Tanggal Publikasi (Opsional)
                    </label>
                    <input type="datetime-local" name="published_at" id="published_at" value="{{ old('published_at') }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-yellow-500 focus:border-yellow-500 @error('published_at') border-red-500 @enderror">
                    <p class="mt-1 text-sm text-gray-500">Jika kosong, akan menggunakan waktu sekarang saat dipublikasikan.</p>
                    @error('published_at')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <!-- Submit Buttons -->
            <div class="flex items-center justify-end space-x-4 pt-6 border-t border-gray-200">
                <a href="{{ route('admin.announcements.index') }}"
                   class="px-4 py-2 bg-gray-300 border border-transparent rounded-md font-semibold text-xs text-gray-700 uppercase tracking-widest hover:bg-gray-400 focus:bg-gray-400 active:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-offset-2 transition ease-in-out duration-150">
                    Batal
                </a>
                <button type="submit"
                        class="px-4 py-2 bg-yellow-500 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-yellow-600 focus:bg-yellow-600 active:bg-yellow-900 focus:outline-none focus:ring-2 focus:ring-yellow-500 focus:ring-offset-2 transition ease-in-out duration-150">
                    Simpan Pengumuman
                </button>
            </div>
        </form>
    </div>
</div>
@endsection