<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Login Admin - TPK</title>
    <link rel="icon" type="image/png" href="{{ asset('favicon.png') }}">

    <!-- Font Akademik -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600,700&display=swap" rel="stylesheet" />

    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>

<!-- BACKGROUND AKADEMIK -->
<body class="font-sans"
      style="background: linear-gradient(135deg, #0f2a4d, #1e3a8a, #1e40af);">

<div class="min-h-screen flex items-center justify-center px-4">

    <!-- CARD -->
    <div
        class="w-full max-w-md bg-white
               rounded-2xl
               p-8 space-y-8
               animate-fade-in-up"
        style="box-shadow: 0 25px 60px rgba(0,0,0,0.35);">

        <!-- HEADER -->
        <div class="text-center">
            <div class="flex justify-center mb-4">
                <!-- LOGO -->
                <div class="text-white px-5 py-3 rounded-xl font-bold text-xl"
                    style="background:#1e3a8a;">
                    TPK
                </div>

            </div>

            <h2 class="text-3xl font-extrabold"
                style="color:#0f172a;">
                Admin Panel
            </h2>

            <p class="mt-2 text-sm"
               style="color:#475569;">
                Masuk ke panel administrasi Program Studi TPK
            </p>
        </div>

        <!-- FORM -->
        <form class="space-y-6" action="{{ route('admin.login') }}" method="POST">
            @csrf

            <!-- Error -->
            @if ($errors->any())
            <div class="bg-red-50 border border-red-200 text-red-700 px-4 py-3 rounded-lg text-sm">
                <ul class="list-disc list-inside">
                    @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
            @endif

            <!-- INPUT -->
            <div class="space-y-4">

                <div>
                    <label class="block text-sm font-semibold mb-1"
                           style="color:#1e293b;">
                        Email
                    </label>
                    <input
                        id="email"
                        name="email"
                        type="email"
                        required
                        value="{{ old('email') }}"
                        placeholder="admin@tpk.ac.id"
                        class="w-full px-4 py-3 rounded-xl border
                               outline-none transition"
                        style="border-color:#cbd5e1;"
                        onfocus="this.style.borderColor='#1e3a8a'; this.style.boxShadow='0 0 0 2px rgba(30,58,138,.2)'"
                        onblur="this.style.borderColor='#cbd5e1'; this.style.boxShadow='none'">
                </div>

                <div>
                    <label class="block text-sm font-semibold mb-1"
                           style="color:#1e293b;">
                        Password
                    </label>
                    <input
                        id="password"
                        name="password"
                        type="password"
                        required
                        placeholder="••••••••"
                        class="w-full px-4 py-3 rounded-xl border
                               outline-none transition"
                        style="border-color:#cbd5e1;"
                        onfocus="this.style.borderColor='#173a5e'; this.style.boxShadow='0 0 0 2px rgba(23,58,94,.15)'"
                        onblur="this.style.borderColor='#cbd5e1'; this.style.boxShadow='none'">
                </div>

            </div>

            <!-- REMEMBER -->
            <div class="flex items-center">
                <input
                    id="remember"
                    name="remember"
                    type="checkbox"
                    class="h-4 w-4 rounded"
                    style="accent-color:#1e3a8a;">
                <label for="remember" class="ml-2 text-sm"
                       style="color:#334155;">
                    Ingat saya
                </label>
            </div>

            <!-- BUTTON -->
            <button
                type="submit"
                class="w-full flex items-center justify-center gap-2
                    text-white font-semibold
                    py-3 rounded-xl
                    transition-all duration-300"
                style="background:#1e3a8a;"
                onmouseover="this.style.background='#1e40af'"
                onmouseout="this.style.background='#1e3a8a'">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2"
                     viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round"
                          d="M12 11c0-1.657-1.343-3-3-3S6 9.343 6 11v3h6v-3zm0 0V9a6 6 0 0112 0v2m-6 5v5m-6 0h12"/>
                </svg>

                Masuk
            </button>

        </form>

    </div>
</div>

<style>
@keyframes fade-in-up {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.animate-fade-in-up {
    animation: fade-in-up .6s ease-out;
}
</style>

</body>
</html>
