@extends('layouts.frontend')

@section('title', 'Akademik - TPK')

@section('content')
<!-- Header -->
<div class="px-8 md:px-16 py-24 bg-blue-950 text-center">

        <h1 class="text-4xl md:text-5xl font-bold tracking-tight">
               <span class="text-white">Program</span>
                <span class="text-yellow-400"> Akademik</span>
        </h1>

        <p class="text-lg md:text-xl text-blue-100 max-w-2xl mx-auto mt-6">
            Kurikulum dan informasi akademik Program Studi TPK
        </p>

    </div>


        <!-- Content -->
        <div class="space-y-16">
            <!-- Kurikulum -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                <div class="bg-gradient-to-br from-blue-50 to-slate-50 p-8 rounded-2xl border border-blue-100">
                    <div class="flex items-center mb-6">
                        <div class="w-12 h-12 bg-blue-500 rounded-xl flex items-center justify-center mr-4">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </div>
                        <h2 class="text-2xl font-bold text-slate-900">Mata Kuliah Wajib</h2>
                    </div>
                    <ul class="space-y-3">
                        <li class="flex items-center text-slate-700">
                            <div class="w-2 h-2 bg-blue-500 rounded-full mr-3 flex-shrink-0"></div>
                            Kimia Kulit
                        </li>
                        <li class="flex items-center text-slate-700">
                            <div class="w-2 h-2 bg-blue-500 rounded-full mr-3 flex-shrink-0"></div>
                            Teknologi Pengolahan Kulit
                        </li>
                        <li class="flex items-center text-slate-700">
                            <div class="w-2 h-2 bg-blue-500 rounded-full mr-3 flex-shrink-0"></div>
                            Analisis dan Pengendalian Kualitas
                        </li>
                        <li class="flex items-center text-slate-700">
                            <div class="w-2 h-2 bg-blue-500 rounded-full mr-3 flex-shrink-0"></div>
                            Teknologi Lingkungan Industri
                        </li>
                        <li class="flex items-center text-slate-700">
                            <div class="w-2 h-2 bg-blue-500 rounded-full mr-3 flex-shrink-0"></div>
                            Manajemen Industri Kulit
                        </li>
                    </ul>
                </div>

                <div class="bg-white rounded-2xl shadow-lg p-8 border border-slate-100">
                    <div class="flex items-center mb-6">
                        <div class="w-12 h-12 bg-slate-100 rounded-xl flex items-center justify-center mr-4">
                            <svg class="w-6 h-6 text-slate-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </div>
                        <h2 class="text-2xl font-bold text-slate-900">Mata Kuliah Pilihan</h2>
                    </div>
                    <ul class="space-y-3">
                        <li class="flex items-center text-slate-700">
                            <div class="w-2 h-2 bg-slate-400 rounded-full mr-3 flex-shrink-0"></div>
                            Teknologi Finishing Modern
                        </li>
                        <li class="flex items-center text-slate-700">
                            <div class="w-2 h-2 bg-slate-400 rounded-full mr-3 flex-shrink-0"></div>
                            Inovasi Produk Kulit
                        </li>
                        <li class="flex items-center text-slate-700">
                            <div class="w-2 h-2 bg-slate-400 rounded-full mr-3 flex-shrink-0"></div>
                            Bisnis dan Pemasaran Kulit
                        </li>
                        <li class="flex items-center text-slate-700">
                            <div class="w-2 h-2 bg-slate-400 rounded-full mr-3 flex-shrink-0"></div>
                            Teknologi Kulit Berkelanjutan
                        </li>
                        <li class="flex items-center text-slate-700">
                            <div class="w-2 h-2 bg-slate-400 rounded-full mr-3 flex-shrink-0"></div>
                            Riset dan Pengembangan Kulit
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Fasilitas -->
            <div>
                <div class="text-center mb-12">
                    <h2 class="text-3xl md:text-4xl font-bold text-slate-900 mb-4 tracking-tight">Fasilitas Akademik</h2>
                    <p class="text-lg text-slate-600 max-w-2xl mx-auto">Sarana dan prasarana pendukung pembelajaran yang modern dan berkualitas</p>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    <div class="bg-white rounded-xl shadow-sm hover:shadow-xl transition-all duration-300 p-8 border border-slate-100 group">
                        <div class="text-center">
                            <div class="w-16 h-16 bg-gradient-to-br from-blue-100 to-blue-200 rounded-2xl flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                                <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19.428 15.428a2 2 0 00-1.022-.547l-2.387-.477a6 6 0 00-3.86.517l-.318.158a6 6 0 01-3.86.517L6.05 15.21a2 2 0 00-1.806.547M8 4h8l-1 1v5.172a2 2 0 00.586 1.414l5 5c1.26 1.26.367 3.414-1.415 3.414H4.828c-1.782 0-2.674-2.154-1.414-3.414l5-5A2 2 0 009 10.172V5L8 4z"></path>
                                </svg>
                            </div>
                            <h3 class="text-xl font-semibold text-slate-900 mb-3">Laboratorium Modern</h3>
                            <p class="text-slate-600 leading-relaxed">Fasilitas lab dengan peralatan terkini untuk praktikum dan penelitian</p>
                        </div>
                    </div>

                    <div class="bg-white rounded-xl shadow-sm hover:shadow-xl transition-all duration-300 p-8 border border-slate-100 group">
                        <div class="text-center">
                            <div class="w-16 h-16 bg-gradient-to-br from-blue-100 to-blue-200 rounded-2xl flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                                <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.246 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path>
                                </svg>
                            </div>
                            <h3 class="text-xl font-semibold text-slate-900 mb-3">Perpustakaan</h3>
                            <p class="text-slate-600 leading-relaxed">Koleksi buku dan jurnal terkini bidang teknologi kulit</p>
                        </div>
                    </div>

                    <div class="bg-white rounded-xl shadow-sm hover:shadow-xl transition-all duration-300 p-8 border border-slate-100 group">
                        <div class="text-center">
                            <div class="w-16 h-16 bg-gradient-to-br from-blue-100 to-blue-200 rounded-2xl flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                                <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                </svg>
                            </div>
                            <h3 class="text-xl font-semibold text-slate-900 mb-3">Workshop & Seminar</h3>
                            <p class="text-slate-600 leading-relaxed">Kegiatan akademik dan pengembangan kompetensi mahasiswa</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Prestasi -->
            <div>
                <div class="text-center mb-12">
                    <h2 class="text-3xl md:text-4xl font-bold text-slate-900 mb-4 tracking-tight">Prestasi Akademik</h2>
                    <p class="text-lg text-slate-600 max-w-2xl mx-auto">Pencapaian dan pengakuan yang telah diraih Program Studi TPK</p>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                    <div class="bg-gradient-to-br from-blue-50 to-slate-50 rounded-xl p-8 border border-blue-100">
                        <div class="w-12 h-12 bg-blue-500 rounded-xl flex items-center justify-center mb-6">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z"></path>
                            </svg>
                        </div>
                        <h3 class="text-lg font-semibold text-slate-900 mb-3">Juara Nasional Inovasi</h3>
                        <p class="text-slate-600 leading-relaxed">Tim mahasiswa TPK meraih juara dalam kompetisi inovasi produk kulit tingkat nasional</p>
                    </div>

                    <div class="bg-gradient-to-br from-green-50 to-emerald-50 rounded-xl p-8 border border-green-100">
                        <div class="w-12 h-12 bg-green-500 rounded-xl flex items-center justify-center mb-6">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                            </svg>
                        </div>
                        <h3 class="text-lg font-semibold text-slate-900 mb-3">Akreditasi B</h3>
                        <p class="text-slate-600 leading-relaxed">Program Studi TPK telah terakreditasi B oleh BAN-PT</p>
                    </div>

                    <div class="bg-gradient-to-br from-amber-50 to-yellow-50 rounded-xl p-8 border border-amber-100">
                        <div class="w-12 h-12 bg-amber-500 rounded-xl flex items-center justify-center mb-6">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                            </svg>
                        </div>
                        <h3 class="text-lg font-semibold text-slate-900 mb-3">Kerjasama Industri</h3>
                        <p class="text-slate-600 leading-relaxed">Bermitra dengan 15 perusahaan kulit terkemuka di Indonesia</p>
                    </div>
                </div>
            </div>

            <!-- CTA Section -->
            <div class="mt-16 text-center">
                <div class="bg-gradient-to-r from-slate-900 to-slate-800 rounded-xl p-8 md:p-12 text-white">
                    <h2 class="text-2xl md:text-3xl font-bold mb-4">Siap Bergabung?</h2>
                    <p class="text-lg text-slate-300 mb-8 max-w-2xl mx-auto">
                        Mulai perjalanan akademik Anda di Program Studi TPK dengan kurikulum modern dan fasilitas terbaik
                    </p>
                    <a href="{{ route('frontend.kontak') }}" class="bg-blue-500 hover:bg-blue-600 text-white font-semibold px-8 py-4 rounded-lg transition-all duration-200 transform hover:scale-105 shadow-lg inline-flex items-center">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                        </svg>
                        Hubungi Kami
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection