@extends('layouts.frontend')

@section('title', 'Berita - TPK')

@section('content')
<div class="px-8 md:px-16 py-24 bg-blue-950 text-center">

        <h1 class="text-4xl md:text-5xl font-bold tracking-tight">
            <span class="text-white">Portal</span>
            <span class="text-yellow-400"> Berita</span>
        </h1>

        <p class="text-lg md:text-xl text-blue-100 max-w-2xl mx-auto mt-6">
            Informasi penting dan pengumuman resmi Program Studi TPK
        </p>

    </div>



    <div class="py-16">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">

        @if($news->count() > 0)
        <!-- News Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            @foreach($news as $item)
            <article class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-shadow">
                @if($item->image)
                <img src="{{ $item->image_url }}" alt="{{ $item->title }}" class="w-full h-48 object-cover">
                @else
                <div class="w-full h-48 bg-gray-200 flex items-center justify-center">
                    <svg class="w-12 h-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"></path>
                    </svg>
                </div>
                @endif

                <div class="p-6">
                    <div class="text-sm text-blue-600 font-medium mb-2">{{ $item->published_at->format('d M Y') }}</div>
                    <h2 class="text-xl font-semibold text-gray-900 mb-3 line-clamp-2">
                        <a href="{{ route('frontend.berita.show', $item) }}" class="hover:text-blue-600 transition-colors">
                            {{ $item->title }}
                        </a>
                    </h2>
                    <p class="text-gray-600 text-sm line-clamp-3 mb-4">{{ strip_tags($item->content) }}</p>
                    <a href="{{ route('frontend.berita.show', $item) }}" class="inline-flex items-center text-blue-600 hover:text-blue-800 text-sm font-medium">
                        Baca Selengkapnya
                        <svg class="ml-1 w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                        </svg>
                    </a>
                </div>
            </article>
            @endforeach
        </div>

        <!-- Pagination -->
        <div class="mt-12">
            {{ $news->links() }}
        </div>
        @else
        <!-- Empty State -->
        <div class="text-center py-16">
            <svg class="mx-auto h-24 w-24 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"></path>
            </svg>
            <h3 class="mt-4 text-lg font-medium text-gray-900">Belum ada berita</h3>
            <p class="mt-2 text-gray-500">Berita akan segera dipublikasikan.</p>
        </div>
        @endif

        </div>
    </div>

</section>
@endsection
