@extends('layouts.frontend')

@section('title', $news->title . ' - TPK')

@section('content')
<section class="py-16 bg-gray-50">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Breadcrumb -->
        <nav class="mb-8">
            <div class="flex items-center justify-between mb-4">
                <a href="{{ route('frontend.berita.index') }}" class="inline-flex items-center text-blue-600 hover:text-blue-800 text-sm font-medium transition-colors">
                    <svg class="mr-1 w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                    </svg>
                    Kembali ke Berita
                </a>
            </div>
            <ol class="flex items-center space-x-2 text-sm text-gray-500">
                <li><a href="{{ route('home') }}" class="hover:text-blue-600">Beranda</a></li>
                <li><span>/</span></li>
                <li><a href="{{ route('frontend.berita.index') }}" class="hover:text-blue-600">Berita</a></li>
                <li><span>/</span></li>
                <li class="text-gray-900">{{ $news->title }}</li>
            </ol>
        </nav>

        <!-- Article Header -->
        <header class="mb-8">
            @if($news->image)
            <img src="{{ $news->image_url }}" alt="{{ $news->title }}" class="w-full h-64 md:h-96 object-cover rounded-lg mb-6">
            @endif

            <div class="flex items-center text-sm text-gray-500 mb-4">
                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                </svg>
                {{ $news->published_at->format('l, d F Y') }}

                <span class="mx-2">•</span>

                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                </svg>
                {{ $news->user->name }}
            </div>

            <h1 class="text-3xl md:text-4xl font-bold text-gray-900 mb-6">{{ $news->title }}</h1>
        </header>

        <!-- Article Content -->
        <article class="prose prose-lg max-w-none mb-12">
            {!! $news->content !!}
        </article>

        <!-- Article Footer -->
        <footer class="border-t border-gray-200 pt-8">
            <div class="flex items-center justify-between">
                <div class="text-sm text-gray-500">
                    Dipublikasikan pada {{ $news->published_at->format('d F Y') }}
                </div>

                <a href="{{ route('frontend.berita.index') }}" class="inline-flex items-center text-blue-600 hover:text-blue-800 text-sm font-medium transition-colors">
                    <svg class="mr-1 w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                    </svg>
                    Kembali ke Berita
                </a>
            </div>
        </footer>
    </div>
</section>

<!-- Related News -->
@if($relatedNews->count() > 0)
<section class="py-16 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-2xl font-bold text-gray-900 mb-8">Berita Lainnya</h2>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            @foreach($relatedNews as $related)
            <article class="bg-gray-50 rounded-lg overflow-hidden hover:shadow-md transition-shadow">
                @if($related->image)
                <img src="{{ $related->image_url }}" alt="{{ $related->title }}" class="w-full h-32 object-cover">
                @else
                <div class="w-full h-32 bg-gray-200 flex items-center justify-center">
                    <svg class="w-8 h-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"></path>
                    </svg>
                </div>
                @endif

                <div class="p-4">
                    <div class="text-xs text-blue-600 font-medium mb-2">{{ $related->published_at->format('d M Y') }}</div>
                    <h3 class="text-sm font-semibold text-gray-900 mb-2 line-clamp-2">
                        <a href="{{ route('frontend.berita.show', $related) }}" class="hover:text-blue-600 transition-colors">
                            {{ $related->title }}
                        </a>
                    </h3>
                    <a href="{{ route('frontend.berita.show', $related) }}" class="text-xs text-blue-600 hover:text-blue-800 font-medium">
                        Baca →
                    </a>
                </div>
            </article>
            @endforeach
        </div>
    </div>
</section>
@endif
@endsection