@extends('layouts.frontend')

@section('title', 'Pengumuman - TPK')

@section('content')
<section class="bg-gray-50">

    <!-- HEADER FULL -->
    <div class="px-8 md:px-16 py-24 bg-blue-950 text-center">

        <h1 class="text-4xl md:text-5xl font-bold tracking-tight">
            <span class="text-white">Pengumuman</span>
            <span class="text-yellow-400"> Program Studi</span>
        </h1>

        <p class="text-lg md:text-xl text-blue-100 max-w-2xl mx-auto mt-6">
            Informasi penting dan pengumuman resmi Program Studi TPK
        </p>

    </div>


    <!-- CONTENT -->
    <div class="py-20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">

            @if($announcements->count() > 0)
            <!-- Announcements List -->
            <div class="space-y-6">
                @foreach($announcements as $announcement)
                <article class="bg-white rounded-xl shadow-md overflow-hidden hover:shadow-xl transition duration-300">
                    <div class="p-6">
                        <div class="flex items-start space-x-4">

                            <div class="flex-shrink-0">
                                <div class="w-12 h-12 bg-yellow-100 rounded-xl flex items-center justify-center">
                                    <svg class="w-6 h-6 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M11 5.882V19.24a1.76 1.76 0 01-3.417.592l-2.147-6.15M18 13a3 3 0 100-6M5.436 13.683A4.001 4.001 0 017 6h1.832c4.1 0 7.625-1.234 9.168-3v14c-1.543-1.766-5.067-3-9.168-3H7a3.988 3.988 0 01-1.564-.317z">
                                        </path>
                                    </svg>
                                </div>
                            </div>

                            <div class="flex-1 min-w-0">
                                <div class="flex items-center justify-between mb-2">
                                    <div class="text-sm text-blue-600 font-medium">
                                        {{ $announcement->published_at->format('d M Y') }}
                                    </div>

                                    @if($announcement->attachment)
                                    <a href="{{ asset('storage/' . $announcement->attachment) }}" target="_blank"
                                        class="inline-flex items-center text-sm text-gray-500 hover:text-blue-600">
                                        <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                            </path>
                                        </svg>
                                        Lampiran
                                    </a>
                                    @endif
                                </div>

                                <h2 class="text-xl font-semibold text-gray-900 mb-3">
                                    <a href="{{ route('frontend.pengumuman.show', $announcement) }}"
                                        class="hover:text-blue-600 transition-colors">
                                        {{ $announcement->title }}
                                    </a>
                                </h2>

                                <p class="text-gray-600 text-sm mb-4 line-clamp-3">
                                    {{ strip_tags($announcement->content) }}
                                </p>

                                <a href="{{ route('frontend.pengumuman.show', $announcement) }}"
                                    class="inline-flex items-center text-blue-600 hover:text-blue-800 text-sm font-medium">
                                    Baca Selengkapnya
                                    <svg class="ml-1 w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M9 5l7 7-7 7"></path>
                                    </svg>
                                </a>
                            </div>

                        </div>
                    </div>
                </article>
                @endforeach
            </div>

            <!-- Pagination -->
            <div class="mt-12">
                {{ $announcements->links() }}
            </div>

            @else
            <!-- Empty State -->
            <div class="text-center py-16">
                <svg class="mx-auto h-24 w-24 text-gray-400" fill="none" stroke="currentColor"
                    viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M11 5.882V19.24a1.76 1.76 0 01-3.417.592l-2.147-6.15M18 13a3 3 0 100-6M5.436 13.683A4.001 4.001 0 017 6h1.832c4.1 0 7.625-1.234 9.168-3v14c-1.543-1.766-5.067-3-9.168-3H7a3.988 3.988 0 01-1.564-.317z">
                    </path>
                </svg>

                <h3 class="mt-4 text-lg font-medium text-gray-900">
                    Belum ada pengumuman
                </h3>

                <p class="mt-2 text-gray-500">
                    Pengumuman akan segera dipublikasikan.
                </p>
            </div>
            @endif

        </div>
    </div>

</section>
@endsection
