@extends('layouts.frontend')

@section('title', $announcement->title . ' - TPK')

@section('content')
<section class="py-16 bg-gray-50">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Breadcrumb -->
        <nav class="mb-8">
            <ol class="flex items-center space-x-2 text-sm text-gray-500">
                <li><a href="{{ route('home') }}" class="hover:text-blue-600">Beranda</a></li>
                <li><span>/</span></li>
                <li><a href="{{ route('frontend.pengumuman.index') }}" class="hover:text-blue-600">Pengumuman</a></li>
                <li><span>/</span></li>
                <li class="text-gray-900">{{ $announcement->title }}</li>
            </ol>
        </nav>

        <!-- Announcement Header -->
        <header class="bg-white rounded-lg shadow-md p-8 mb-8">
            <div class="flex items-start space-x-4">
                <div class="flex-shrink-0">
                    <div class="w-16 h-16 bg-yellow-100 rounded-lg flex items-center justify-center">
                        <svg class="w-8 h-8 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5.882V19.24a1.76 1.76 0 01-3.417.592l-2.147-6.15M18 13a3 3 0 100-6M5.436 13.683A4.001 4.001 0 017 6h1.832c4.1 0 7.625-1.234 9.168-3v14c-1.543-1.766-5.067-3-9.168-3H7a3.988 3.988 0 01-1.564-.317z"></path>
                        </svg>
                    </div>
                </div>

                <div class="flex-1">
                    <div class="flex items-center justify-between mb-4">
                        <div class="text-sm text-blue-600 font-medium bg-blue-50 px-3 py-1 rounded-full">
                            {{ $announcement->published_at->format('l, d F Y') }}
                        </div>
                        @if($announcement->attachment)
                        <a href="{{ asset('storage/' . $announcement->attachment) }}" target="_blank"
                           class="inline-flex items-center px-4 py-2 bg-gray-100 hover:bg-gray-200 text-gray-700 text-sm font-medium rounded-lg transition-colors">
                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                            Download Lampiran
                        </a>
                        @endif
                    </div>

                    <h1 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">{{ $announcement->title }}</h1>

                    <div class="flex items-center text-sm text-gray-500">
                        <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                        </svg>
                        {{ $announcement->user->name }}
                    </div>
                </div>
            </div>
        </header>

        <!-- Announcement Content -->
        <article class="bg-white rounded-lg shadow-md p-8 mb-8">
            <div class="prose prose-lg max-w-none">
                {!! $announcement->content !!}
            </div>
        </article>

        <!-- Announcement Footer -->
        <footer class="bg-gray-100 rounded-lg p-6">
            <div class="flex items-center justify-between">
                <div class="text-sm text-gray-500">
                    Dipublikasikan pada {{ $announcement->published_at->format('d F Y') }}
                </div>

                <a href="{{ route('frontend.pengumuman.index') }}" class="inline-flex items-center text-blue-600 hover:text-blue-800 text-sm font-medium">
                    <svg class="mr-1 w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                    </svg>
                    Kembali ke Pengumuman
                </a>
            </div>
        </footer>
    </div>
</section>

<!-- Related Announcements -->
@if($relatedAnnouncements->count() > 0)
<section class="py-16 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-2xl font-bold text-gray-900 mb-8">Pengumuman Lainnya</h2>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            @foreach($relatedAnnouncements as $related)
            <div class="bg-gray-50 rounded-lg p-6 hover:shadow-md transition-shadow">
                <div class="flex items-start space-x-3 mb-4">
                    <div class="w-10 h-10 bg-yellow-100 rounded-lg flex items-center justify-center flex-shrink-0">
                        <svg class="w-5 h-5 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5.882V19.24a1.76 1.76 0 01-3.417.592l-2.147-6.15M18 13a3 3 0 100-6M5.436 13.683A4.001 4.001 0 017 6h1.832c4.1 0 7.625-1.234 9.168-3v14c-1.543-1.766-5.067-3-9.168-3H7a3.988 3.988 0 01-1.564-.317z"></path>
                        </svg>
                    </div>
                    <div>
                        <div class="text-xs text-blue-600 font-medium mb-1">{{ $related->published_at->format('d M Y') }}</div>
                        <h3 class="text-sm font-semibold text-gray-900 line-clamp-2">
                            <a href="{{ route('frontend.pengumuman.show', $related) }}" class="hover:text-blue-600 transition-colors">
                                {{ $related->title }}
                            </a>
                        </h3>
                    </div>
                </div>
                <a href="{{ route('frontend.pengumuman.show', $related) }}" class="text-xs text-blue-600 hover:text-blue-800 font-medium">
                    Baca selengkapnya →
                </a>
            </div>
            @endforeach
        </div>
    </div>
</section>
@endif
@endsection