@extends('layouts.frontend')

@section('title', 'Dosen - TPPK')
<link rel="icon" type="image/png" href="{{ asset('favicon.png') }}">
@section('content')
<section class="bg-gray-50">

    <!-- HEADER FULL -->
    <div class="px-8 md:px-16 py-24 bg-blue-950 text-center">

        <h1 class="text-4xl md:text-5xl font-bold tracking-tight">
            <span class="text-white">Dosen</span>
            <span class="text-yellow-400"> Program Studi</span>
        </h1>

        <p class="text-lg md:text-xl text-blue-100 max-w-2xl mx-auto mt-6">
            Tenaga pengajar profesional di bidang Teknologi Pengolahan Kulit
        </p>

    </div>



    <!-- CONTENT -->
    <div class="py-20">
        <div class="max-w-6xl mx-auto px-4">

            <div class="bg-white shadow-lg border border-gray-200 p-12">

                <!-- Title dengan icon -->
                <div class="flex items-center gap-4 mb-10">

                    <div class="w-14 h-14 bg-blue-100 flex items-center justify-center">
                        <!-- ICON DOSEN -->
                        <svg class="w-7 h-7 text-blue-700" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                d="M12 14l9-5-9-5-9 5 9 5z"/>
                            <path stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                d="M12 14l6.16-3.422A12.083 12.083 0 0112 20.055
                                a12.083 12.083 0 01-6.16-9.477L12 14z"/>
                        </svg>
                    </div>

                    <h2 class="text-2xl font-bold text-blue-900">
                        Tenaga Pengajar Profesional
                    </h2>

                </div>



                @php
                    $profile = \App\Models\Profile::where('section', 'dosen')->active()->first();
                @endphp

                    @if($profile)

                    @php
                    $dosen = [
                        [
                            'nama' => 'Dr. Budi Santoso, S.T., M.T.',
                            'bidang' => 'Teknologi Pengolahan Kulit',
                            'desk' => 'Ahli proses penyamakan dan quality control industri kulit.'
                        ],
                        [
                            'nama' => 'Dr. Sari Wulandari, S.T., M.Sc.',
                            'bidang' => 'Kimia Kulit',
                            'desk' => 'Fokus pada inovasi bahan ramah lingkungan.'
                        ],
                        [
                            'nama' => 'Andi Pratama, S.T., M.T.',
                            'bidang' => 'Manajemen Industri Kulit',
                            'desk' => 'Berpengalaman dalam manajemen produksi skala besar.'
                        ],
                        [
                            'nama' => 'Rina Maharani, S.Si., M.T.',
                            'bidang' => 'Analisis Kualitas',
                            'desk' => 'Spesialis pengujian standar mutu kulit ekspor.'
                        ],
                        [
                            'nama' => 'Dr. Dedi Kurniawan, S.T., M.T.',
                            'bidang' => 'Teknologi Finishing',
                            'desk' => 'Meneliti teknik finishing modern dan tahan lama.'
                        ],
                        [
                            'nama' => 'Yoga Saputra, S.T., M.T.',
                            'bidang' => 'Teknologi Lingkungan',
                            'desk' => 'Fokus pada pengolahan limbah industri kulit.'
                        ],
                    ];
                    @endphp


                    <div class="grid sm:grid-cols-2 md:grid-cols-2 lg:grid-cols-4 gap-8">

                    @foreach($dosen as $dsn)

                    <div class="bg-white border rounded-xl shadow hover:shadow-xl transition overflow-hidden group">

                        <!-- FOTO -->
                        <div class="relative overflow-hidden">
                            <img 
                                src="https://ui-avatars.com/api/?name={{ urlencode($dsn['nama']) }}&background=1e3a8a&color=fff&size=300"
                                class="w-full h-64 object-cover group-hover:scale-105 transition duration-300"
                            >

                            <!-- Frame hover -->
                            <div class="absolute inset-0 border-2 border-blue-700 opacity-0 group-hover:opacity-100 transition"></div>
                        </div>

                        <!-- INFO -->
                        <div class="p-5 text-center">

                            <h3 class="font-bold text-lg text-gray-900">
                                {{ $dsn['nama'] }}
                            </h3>

                            <p class="text-blue-700 text-sm font-medium">
                                {{ $dsn['bidang'] }}
                            </p>

                            <p class="text-gray-500 text-sm mt-2">
                                {{ $dsn['desk'] }}
                            </p>

                        </div>

                    </div>

                    @endforeach

                    </div>

                    @else


                    <div class="text-center py-12">
                        <h3 class="text-xl font-semibold text-gray-900 mb-2">
                            Konten Sedang Dipersiapkan
                        </h3>
                        <p class="text-gray-500">
                            Informasi dosen program studi sedang dalam proses penyusunan.
                        </p>
                    </div>

                @endif

            </div>

        </div>
    </div>

</section>
@endsection
