<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Frontend\HomeController;
use App\Http\Controllers\Admin\AuthController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Frontend\TracerController;

Route::get('/', [HomeController::class, 'index'])->name('home');

// Admin Routes
Route::prefix('admin')->name('admin.')->group(function () {
    // Guest routes
    Route::get('/login', [AuthController::class, 'showLoginForm'])
    ->name('login');
    Route::post('/login', [AuthController::class, 'login']);

    // Authenticated routes
    Route::middleware(['auth', 'role:admin'])->group(function () {
        Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
        Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

        // News routes
        Route::resource('news', \App\Http\Controllers\Admin\NewsController::class);

        // Announcements routes
        Route::resource('announcements', \App\Http\Controllers\Admin\AnnouncementController::class);

        // Profiles routes
        Route::resource('profiles', \App\Http\Controllers\Admin\ProfileController::class);

        // Slider routes
        Route::resource('sliders', \App\Http\Controllers\Admin\SliderController::class);
        Route::post('sliders/{id}/toggle', [\App\Http\Controllers\Admin\SliderController::class, 'toggle'])->name('sliders.toggle');

        // User management (Super Admin only)
        Route::middleware('role:super_admin')->group(function () {
            Route::resource('users', \App\Http\Controllers\Admin\UserController::class);
        });
    });
});

// Frontend Routes
Route::name('frontend.')->group(function () {
    // Profile routes
    Route::prefix('profil-prodi')->name('profile.')->group(function () {
        Route::get('/visi-misi', function () {
            return view('frontend.profile.visi-misi');
        })->name('visi-misi');

        Route::get('/sejarah', function () {
            return view('frontend.profile.sejarah');
        })->name('sejarah');

        Route::get('/dosen', function () {
            return view('frontend.profile.dosen');
        })->name('dosen');
    });

    // Academic routes
    Route::get('/akademik', function () {
        return view('frontend.akademik');
    })->name('akademik');

    // News routes
    Route::get('/berita', [\App\Http\Controllers\Frontend\NewsController::class, 'index'])->name('berita.index');
    Route::get('/berita/{news}', [\App\Http\Controllers\Frontend\NewsController::class, 'show'])->name('berita.show');

    // Announcement routes
    Route::get('/pengumuman', [\App\Http\Controllers\Frontend\AnnouncementController::class, 'index'])->name('pengumuman.index');
    Route::get('/pengumuman/{announcement}', [\App\Http\Controllers\Frontend\AnnouncementController::class, 'show'])->name('pengumuman.show');

    // Contact route
    Route::get('/kontak', function () {
        return view('frontend.kontak');
    })->name('kontak');

    // Tracer Route
    Route::get('/tracer', function () {
    return view('frontend.tracer.index');
    })->name('tracer.index');

});
