<?php $__env->startSection('title', 'Kelola Slider'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-white rounded-lg shadow-sm border border-gray-200">
    <div class="p-6 border-b border-gray-200">
        <div class="flex justify-between items-center">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Kelola Slider</h1>
                <p class="text-gray-600 mt-1">Kelola gambar slider yang ditampilkan di halaman utama</p>
            </div>
            <a href="<?php echo e(route('admin.sliders.create')); ?>"
               class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg font-medium transition duration-200 flex items-center">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                </svg>
                Tambah Slider
            </a>
        </div>
    </div>

    <div class="p-6">
        <?php if(session('success')): ?>
        <div class="mb-6 bg-green-50 border border-green-200 text-green-700 px-4 py-3 rounded-lg">
            <?php echo e(session('success')); ?>

        </div>
        <?php endif; ?>

        <?php if($sliders->count() > 0): ?>
        <div class="space-y-4">
            <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="border border-gray-200 rounded-lg p-4 hover:shadow-md transition duration-200">
                <div class="flex items-center justify-between">
                    <div class="flex items-center space-x-4">
                        <img src="<?php echo e($slider->image_url); ?>" alt="<?php echo e($slider->title); ?>"
                             class="w-20 h-12 object-cover rounded border">
                        <div>
                            <h3 class="font-semibold text-gray-900"><?php echo e($slider->title); ?></h3>
                            <p class="text-sm text-gray-600"><?php echo e(Str::limit($slider->description, 50)); ?></p>
                            <div class="flex items-center mt-1 space-x-4">
                                <span class="text-xs text-gray-500">Order: <?php echo e($slider->order); ?></span>
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                     <?php echo e($slider->is_active ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'); ?>">
                                    <?php echo e($slider->is_active ? 'Aktif' : 'Tidak Aktif'); ?>

                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="flex items-center space-x-2">
                        <button onclick="toggleStatus(<?php echo e($slider->id); ?>)"
                                class="text-gray-500 hover:text-gray-700 p-1 rounded transition duration-200"
                                title="<?php echo e($slider->is_active ? 'Nonaktifkan' : 'Aktifkan'); ?>">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                      d="M<?php echo e($slider->is_active ? '13 10V3L4 14h7v7l9-11h-7z' : '18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192L5.636 18.364M12 3v6m0 6v6m6-12h-6m-6 0h-6'); ?>"></path>
                            </svg>
                        </button>

                        <a href="<?php echo e(route('admin.sliders.edit', $slider)); ?>"
                           class="text-blue-600 hover:text-blue-800 p-1 rounded transition duration-200">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                            </svg>
                        </a>

                        <form method="POST" action="<?php echo e(route('admin.sliders.destroy', $slider)); ?>"
                              onsubmit="return confirm('Apakah Anda yakin ingin menghapus slider ini?')"
                              class="inline">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="text-red-600 hover:text-red-800 p-1 rounded transition duration-200">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                </svg>
                            </button>
                        </form>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <div class="mt-6">
            <?php echo e($sliders->links()); ?>

        </div>
        <?php else: ?>
        <div class="text-center py-12">
            <svg class="mx-auto h-24 w-24 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
            </svg>
            <h3 class="mt-4 text-lg font-medium text-gray-900">Belum ada slider</h3>
            <p class="mt-2 text-gray-500">Tambahkan slider pertama untuk ditampilkan di halaman utama.</p>
            <a href="<?php echo e(route('admin.sliders.create')); ?>"
               class="mt-4 inline-flex items-center px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition duration-200">
                Tambah Slider Baru
            </a>
        </div>
        <?php endif; ?>
    </div>
</div>

<script>
function toggleStatus(id) {
    fetch(`/admin/sliders/${id}/toggle`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify({})
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Terjadi kesalahan saat mengubah status slider.');
    });
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\tpk-web\resources\views/admin/sliders/index.blade.php ENDPATH**/ ?>