<?php $__env->startSection('title', 'Sejarah - TPPK'); ?>

<?php $__env->startSection('content'); ?>
<section class="bg-gray-50">

    <!-- HEADER FULL -->
    <div class="px-8 md:px-16 py-24 bg-blue-950 text-center">

        <h1 class="text-4xl md:text-5xl font-bold tracking-tight">
            <span class="text-white">Sejarah</span>
            <span class="text-yellow-400"> Program Studi</span>
        </h1>

        <p class="text-lg md:text-xl text-blue-100 max-w-2xl mx-auto mt-6">
            Perjalanan dan perkembangan Program Studi TPPK dari masa ke masa
        </p>

    </div>


    <!-- CONTENT -->
    <div class="py-20">
        <div class="max-w-5xl mx-auto px-4">

            <!-- Card utama -->
            <div class="bg-white shadow-lg border border-gray-200 p-12">

                <div class="flex items-center gap-4 mb-10">

                    <!-- ICON HISTORY -->
                    <div class="w-14 h-14 bg-yellow-100 flex items-center justify-center">
                        <svg class="w-7 h-7 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                d="M12 8v4l3 3M12 3a9 9 0 100 18 9 9 0 000-18z"/>
                        </svg>
                    </div>

                    <h2 class="text-2xl font-bold text-blue-900">
                        Perjalanan TPPK
                    </h2>

                </div>


                <?php
                    $profile = \App\Models\Profile::where('section', 'sejarah')->active()->first();
                ?>

                <?php if($profile): ?>

                    <div class="prose max-w-none 
                                prose-lg
                                prose-headings:text-blue-900
                                prose-strong:text-gray-900">

                        <?php echo $profile->content; ?>


                    </div>

                <?php else: ?>

                    <div class="text-center py-12">
                        <h3 class="text-xl font-semibold text-gray-900 mb-2">
                            Konten Sedang Dipersiapkan
                        </h3>
                        <p class="text-gray-500">
                            Informasi sejarah program studi sedang dalam proses penyusunan.
                        </p>
                    </div>

                <?php endif; ?>

            </div>

        </div>
    </div>

</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\tpk-web\resources\views/frontend/profile/sejarah.blade.php ENDPATH**/ ?>