<?php $__env->startSection('title', 'Berita - TPK'); ?>

<?php $__env->startSection('content'); ?>
<div class="px-8 md:px-16 py-24 bg-blue-950 text-center">

        <h1 class="text-4xl md:text-5xl font-bold tracking-tight">
            <span class="text-white">Portal</span>
            <span class="text-yellow-400"> Berita</span>
        </h1>

        <p class="text-lg md:text-xl text-blue-100 max-w-2xl mx-auto mt-6">
            Informasi penting dan pengumuman resmi Program Studi TPK
        </p>

    </div>



    <div class="py-16">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">

        <?php if($news->count() > 0): ?>
        <!-- News Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <?php $__currentLoopData = $news; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <article class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-shadow">
                <?php if($item->image): ?>
                <img src="<?php echo e($item->image_url); ?>" alt="<?php echo e($item->title); ?>" class="w-full h-48 object-cover">
                <?php else: ?>
                <div class="w-full h-48 bg-gray-200 flex items-center justify-center">
                    <svg class="w-12 h-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"></path>
                    </svg>
                </div>
                <?php endif; ?>

                <div class="p-6">
                    <div class="text-sm text-blue-600 font-medium mb-2"><?php echo e($item->published_at->format('d M Y')); ?></div>
                    <h2 class="text-xl font-semibold text-gray-900 mb-3 line-clamp-2">
                        <a href="<?php echo e(route('frontend.berita.show', $item)); ?>" class="hover:text-blue-600 transition-colors">
                            <?php echo e($item->title); ?>

                        </a>
                    </h2>
                    <p class="text-gray-600 text-sm line-clamp-3 mb-4"><?php echo e(strip_tags($item->content)); ?></p>
                    <a href="<?php echo e(route('frontend.berita.show', $item)); ?>" class="inline-flex items-center text-blue-600 hover:text-blue-800 text-sm font-medium">
                        Baca Selengkapnya
                        <svg class="ml-1 w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                        </svg>
                    </a>
                </div>
            </article>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <!-- Pagination -->
        <div class="mt-12">
            <?php echo e($news->links()); ?>

        </div>
        <?php else: ?>
        <!-- Empty State -->
        <div class="text-center py-16">
            <svg class="mx-auto h-24 w-24 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"></path>
            </svg>
            <h3 class="mt-4 text-lg font-medium text-gray-900">Belum ada berita</h3>
            <p class="mt-2 text-gray-500">Berita akan segera dipublikasikan.</p>
        </div>
        <?php endif; ?>

        </div>
    </div>

</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\tpk-web\resources\views/frontend/berita/index.blade.php ENDPATH**/ ?>