<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'TPK - Teknologi Pengolahan Kulit'); ?></title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600,700&display=swap" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <!-- Scripts -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
</head>
<body class="bg-gray-50">
   <!-- Top bar-->
<div class="bg-yellow-400 text-blue-900 text-sm">
    <div class="max-w-7xl mx-auto px-4">
        <div class="flex justify-between items-center h-6">

            <!-- Sosial Media -->
            <div class="flex items-center space-x-4">
                <a href="https://www.facebook.com/profile.php?id=61552881957904" 
                target="_blank"
                class="hover:text-blue-700 transition">
                    <i class="fab fa-facebook-f"></i>
                </a>

                <a href="https://www.instagram.com/politeknikatk?igsh=MThmdnVwaGVmeGJhMQ==" 
                target="_blank"
                class="hover:text-blue-700 transition">
                    <i class="fab fa-instagram"></i>
                </a>

                <a href="#" 
                class="hover:text-blue-700 transition">
                    <i class="fab fa-youtube"></i>
                </a>
            </div>

            <!-- Kontak -->
            <div class="hidden md:flex items-center space-x-6 text-sm text-black">

            <!-- Email -->
            <span class="flex items-center gap-2">
                <svg xmlns="http://www.w3.org/2000/svg"
                    class="h-4 w-4"
                    fill="none"
                    viewBox="0 0 24 24"
                    stroke="currentColor"
                    stroke-width="1.8">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="M21 8V6a2 2 0 00-2-2H5a2 2 0 00-2 2v2m18 0v10a2 2 0 01-2 2H5a2 2 0 01-2-2V8m18 0l-9 6-9-6" />
                </svg>
                tpk@politeknikatk.ac.id
            </span>

            <!-- Telepon -->
            <span class="flex items-center gap-2">
                <svg xmlns="http://www.w3.org/2000/svg"
                    class="h-4 w-4"
                    fill="none"
                    viewBox="0 0 24 24"
                    stroke="currentColor"
                    stroke-width="1.8">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="M3 5a2 2 0 012-2h2.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-1.272.636a11.042 11.042 0 005.516 5.516l.636-1.272a1 1 0 011.21-.502l4.493 1.498A1 1 0 0121 16.72V19a2 2 0 01-2 2h-1C9.163 21 3 14.837 3 7V5z" />
                </svg>
                (021) 1234-5678
            </span>

        </div>


        </div>
    </div>
</div>
<!-- Navigation -->
<nav class="bg-blue-900 sticky top-0 z-50 shadow-lg border-b border-blue-950">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between h-20">
            
            <!-- Logo -->
            <div class="flex items-center">
                <a href="<?php echo e(route('home')); ?>" class="flex items-center space-x-3">
                    
                   
                    <img src="<?php echo e(asset('images/logoatk.png')); ?>" alt="Logo TPK"class="h-12 w-auto object-contain">
                    <div>
                        <div class="font-semibold text-yellow-300">
                            PROGRAM STUDI
                        </div>
                        <div class="text-sm text-blue-100">
                            TEKNOLOGI PENGOLAHAN KULIT
                        </div>
                    </div>
                </a>
            </div>

                <!-- Desktop Navigation -->
                <div class="hidden md:flex items-center space-x-8">
                    <a href="<?php echo e(route('home')); ?>" 
                        class="text-white hover:text-yellow-300 px-3 py-2 rounded-md text-sm font-normal transition-colors">BERANDA</a>
                    <div class="relative group">
                        <button class="text-white hover:text-yellow-300 px-3 py-2 rounded-md text-sm font-normal transition-colors flex items-center">
                            PROFIL PRODI
                            <svg class="ml-1 h-4 w-4" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                            </svg>
                        </button>
                    <div class="absolute left-0 mt-2 w-48 bg-blue-900 rounded-lg shadow-xl opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 transform group-hover:translate-y-1 z-50">
                    <a href="<?php echo e(route('frontend.profile.visi-misi')); ?>" class="block px-4 py-2 text-sm text-blue-100 hover:bg-blue-800 hover:text-white transition">VISI & MISI</a>
                    <a href="<?php echo e(route('frontend.profile.sejarah')); ?>" class="block px-4 py-2 text-sm text-blue-100 hover:bg-blue-800 hover:text-white transition">SEJARAH</a>
                    <a href="<?php echo e(route('frontend.profile.dosen')); ?>" class="block px-4 py-2 text-sm text-blue-100 hover:bg-blue-800 hover:text-white transition">DOSEN</a>
                    </div>

                    </div>
                    <a href="<?php echo e(route('frontend.akademik')); ?>" class="text-white hover:text-yellow-300 px-3 py-2 rounded-md text-sm font-normal transition-colors">AKADEMIK</a>
                    <a href="<?php echo e(route('frontend.tracer.index')); ?>" class="text-white hover:text-yellow-300 px-3 py-2 rounded-md text-sm font-normal transition-colors">TRACER</a>
                    <a href="<?php echo e(route('frontend.kontak')); ?>" class="text-white hover:text-yellow-300 px-3 py-2 rounded-md text-sm font-normal transition-colors">KONTAK</a>
                </div>

                <!-- Mobile menu button -->
                <div class="md:hidden flex items-center">
                    <button type="button" class="text-white hover:text-yellow-300 p-2" id="mobile-menu-button">
                        <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                        </svg>
                    </button>
                </div>
            </div>

            <!-- Mobile Navigation -->
            <div class="md:hidden hidden" id="mobile-menu">
                <div class="px-2 pt-2 pb-3 space-y-1 bg-white border-t border-white-200">
                    <a href="<?php echo e(route('home')); ?>" class="block px-3 py-2 text-white-700 hover:text-blue-600">Beranda</a>
                    <div class="space-y-1">
                        <div class="px-3 py-2 text-white-900 font-normal">Profil Prodi</div>
                        <a href="<?php echo e(route('frontend.profile.visi-misi')); ?>" class="block px-6 py-2 text-sm text-white-700 hover:text-blue-600">Visi & Misi</a>
                        <a href="<?php echo e(route('frontend.profile.sejarah')); ?>" class="block px-6 py-2 text-sm text-white-700 hover:text-blue-600">Sejarah</a>
                        <a href="<?php echo e(route('frontend.profile.dosen')); ?>" class="block px-6 py-2 text-sm text-white-700 hover:text-blue-600">Dosen</a>
                    </div>
                    <a href="<?php echo e(route('frontend.akademik')); ?>" class="block px-3 py-2 text-white-700 hover:text-blue-600">Akademik</a>
                    <a href="<?php echo e(route('frontend.berita.index')); ?>" class="block px-3 py-2 text-white-700 hover:text-blue-600">Berita</a>
                    <a href="<?php echo e(route('frontend.pengumuman.index')); ?>" class="block px-3 py-2 text-white-700 hover:text-blue-600">Pengumuman</a>
                    <a href="<?php echo e(route('frontend.kontak')); ?>" class="block px-3 py-2 text-white-700 hover:text-blue-600">Kontak</a>
                </div>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="flex-1">
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <!-- Footer -->
    <footer class="bg-gray-900 text-gray">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
                <div class="col-span-1 md:col-span-2">
                    <div class="flex items-center space-x-3 mb-4">
                        <div class="bg-yellow-500 text-gray-900 px-3 py-2 rounded-lg font-bold text-lg">
                            TPK
                        </div>
                        <div>
                            <div class="text-sm text-yellow-400">Program Studi</div>
                            <div class="text-sm text-gray-300">Teknologi pengolahan Kulit</div>
                        </div>
                    </div>
                    <p class="text-gray-300 text-sm leading-relaxed">
                        Program studi yang fokus pada pengembangan teknologi pengolahan kulit
                        dengan pendekatan akademik dan praktis untuk menghasilkan lulusan yang kompeten.
                    </p>
                </div>

                <div>
                    <h3 class="text-lg font-semibold mb-4 text-yellow-400">Program Studi</h3>
                    <ul class="space-y-2 text-sm">
                        <li><a href="<?php echo e(route('frontend.profile.visi-misi')); ?>" class="text-gray-300 hover:text-yellow-400 transition-colors">Visi & Misi</a></li>
                        <li><a href="<?php echo e(route('frontend.profile.sejarah')); ?>" class="text-gray-300 hover:text-yellow-400 transition-colors">Sejarah</a></li>
                        <li><a href="<?php echo e(route('frontend.profile.dosen')); ?>" class="text-gray-300 hover:text-yellow-400 transition-colors">Dosen</a></li>
                        <li><a href="<?php echo e(route('frontend.akademik')); ?>" class="text-gray-300 hover:text-yellow-400 transition-colors">Akademik</a></li>
                    </ul>
                </div>

                <div>
                    <h3 class="text-lg font-semibold mb-4 text-yellow-400">Informasi</h3>
                    <ul class="space-y-2 text-sm">
                        <li><a href="<?php echo e(route('frontend.berita.index')); ?>" class="text-gray-300 hover:text-yellow-400 transition-colors">Berita</a></li>
                        <li><a href="<?php echo e(route('frontend.pengumuman.index')); ?>" class="text-gray-300 hover:text-yellow-400 transition-colors">Pengumuman</a></li>
                        <li><a href="<?php echo e(route('frontend.kontak')); ?>" class="text-gray-300 hover:text-yellow-400 transition-colors">Kontak</a></li>
                        <li><a href="<?php echo e(route('admin.login')); ?>" class="text-gray-300 hover:text-yellow-400 transition-colors">Login Admin</a></li>
                    </ul>
                </div>
            </div>

            <div class="border-t border-gray-800 mt-8 pt-8 text-center">
                <p class="text-gray-400 text-sm">
                    &copy; <?php echo e(date('Y')); ?> Program Studi Teknologi pengolahan Kulit. All rights reserved.
                </p>
            </div>
        </div>
    </footer>

    <!-- Mobile menu script -->
    <script>
        document.getElementById('mobile-menu-button').addEventListener('click', function() {
            const menu = document.getElementById('mobile-menu');
            menu.classList.toggle('hidden');
        });
    </script>
</body>
</html><?php /**PATH C:\xampp\htdocs\tpk-web\resources\views/layouts/frontend.blade.php ENDPATH**/ ?>