<?php $__env->startSection('title', 'Visi & Misi - TPPK'); ?>

<?php $__env->startSection('content'); ?>
<section class="bg-gray-50">

    <!-- HEADER -->
    <div class="px-8 md:px-16 py-24 bg-blue-950 text-center">
        <h1 class="text-4xl md:text-5xl font-bold tracking-tight">
            <span class="text-yellow-400">Visi</span>
            <span class="text-white"> & Misi</span>
        </h1>

        <p class="text-lg md:text-xl text-blue-100 max-w-2xl mx-auto mt-6">
            Arah dan tujuan Program Studi Teknologi Pengolahan Kulit
        </p>
    </div>


    <!-- CONTENT -->
    <div class="py-20">
        <div class="max-w-6xl mx-auto px-4">

            <?php
                $profile = \App\Models\Profile::where('section', 'visi_misi')->active()->first();

                $visi = '';
                $misi = '';

                if($profile){
                    preg_match('/Visi(.*?)(Misi|$)/is', $profile->content, $visiMatch);
                    preg_match('/Misi(.*)/is', $profile->content, $misiMatch);

                    $visi = $visiMatch[1] ?? '';
                    $misi = $misiMatch[1] ?? '';
                }
            ?>


            <?php if($profile): ?>

            <div class="grid md:grid-cols-2 gap-12">

                <!-- VISI -->
                <div class="bg-white p-12 shadow-lg border border-gray-200
                            hover:shadow-2xl transition duration-300">

                    <div class="flex items-center gap-4 mb-8">

                        <!-- NEW ICON (Lamp / Idea) -->
                        <div class="w-16 h-16 bg-blue-100 flex items-center justify-center">
                            <svg class="w-8 h-8 text-blue-800" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                    d="M9 18h6M10 22h4M12 2a7 7 0 00-4 12c.5.5 1 1.5 1 2h6c0-.5.5-1.5 1-2a7 7 0 00-4-12z"/>
                            </svg>
                        </div>

                        <h2 class="text-3xl font-bold text-blue-900">
                            Visi
                        </h2>

                    </div>

                    <div class="text-gray-600 leading-relaxed space-y-4">
                        <?php echo $visi; ?>

                    </div>

                </div>



                <!-- MISI -->
                <div class="bg-white p-12 shadow-lg border border-gray-200
                            hover:shadow-2xl transition duration-300">

                    <div class="flex items-center gap-4 mb-8">

                        <!-- NEW ICON (Checklist / Strategy) -->
                        <div class="w-16 h-16 bg-yellow-100 flex items-center justify-center">
                            <svg class="w-8 h-8 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                    d="M5 13l4 4L19 7"/>
                            </svg>
                        </div>

                        <h2 class="text-3xl font-bold text-yellow-500">
                            Misi
                        </h2>

                    </div>

                    <div class="text-gray-600 leading-relaxed space-y-4">
                        <?php echo $misi; ?>

                    </div>

                </div>

            </div>

            <?php else: ?>

            <div class="bg-white p-12 text-center shadow">
                <h3 class="text-xl font-semibold">Konten Sedang Dipersiapkan</h3>
            </div>

            <?php endif; ?>

        </div>
    </div>

</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\tpk-web\resources\views/frontend/profile/visi-misi.blade.php ENDPATH**/ ?>